/******/ (() => { // webpackBootstrap
/******/     "use strict";
/******/     var __webpack_modules__ = ({

/***/ "./src/content/index.ts":
/*!******************************!*\
  !*** ./src/content/index.ts ***!
  \******************************/
/***/ (function() {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// Get current domain dynamically
function getCurrentDomain() {
    return window.location.hostname;
}
// console.log('Initial domain detected:', getCurrentDomain());
// Helper function to normalize URL for comparison
function normalizeUrl(url) {
    return url.replace(/^https?:\/\//, '').replace(/\/.*$/, '').replace(/^www\./, '');
}
// Improved domain matching function - more strict for security
function domainsMatch(url1, url2) {
    const strip = (d) => d.replace(/^https?:\/\//, '').replace(/\/.*$/, '').replace(/^www\./, '').toLowerCase();
    const A = strip(url1);
    const B = strip(url2);
    // Exact match (most secure)
    if (A === B)
        return true;
    // Subdomain match (e.g., login.example.com matches example.com)
    // Only allow if the stored credential is for the main domain
    if (A.includes('.') && !B.includes('.')) {
        // If stored credential is for main domain (e.g., example.com) and current is subdomain (e.g., login.example.com)
        if (A.endsWith('.' + B))
            return true;
    }
    else if (B.includes('.') && !A.includes('.')) {
        // If stored credential is for subdomain (e.g., login.example.com) and current is main domain (e.g., example.com)
        if (B.endsWith('.' + A))
            return true;
    }
    // For security, don't allow cross-domain matches
    // Only allow exact matches and subdomain relationships
    return false;
}
// Safe HTML setting function to avoid innerHTML security warnings
function setSafeHTML(element, html) {
    try {
        // Create a temporary container to parse the HTML safely
        const tempDiv = document.createElement('div');
        tempDiv.innerHTML = html;
        // Clear the target element
        element.innerHTML = '';
        // Move all child nodes from temp to target
        while (tempDiv.firstChild) {
            element.appendChild(tempDiv.firstChild);
        }
    }
    catch (error) {
        // Fallback: use textContent for safety
        console.warn('Failed to set HTML safely, using textContent:', error);
        element.textContent = html.replace(/<[^>]*>/g, ''); // Strip HTML tags
    }
}
// Function to detect if input is inside a modal/overlay
function isInsideModal(element) {
    let current = element;
    while (current && current !== document.body) {
        const computedStyle = window.getComputedStyle(current);
        const zIndex = parseInt(computedStyle.zIndex) || 0;
        const position = computedStyle.position;
        // Check if element has high z-index and is positioned (modal characteristics)
        if (zIndex > 1000 && (position === 'fixed' || position === 'absolute')) {
            return true;
        }
        // Check for common modal classes/attributes
        if (current.classList.contains('modal') ||
            current.classList.contains('overlay') ||
            current.classList.contains('dialog') ||
            current.classList.contains('popup') ||
            current.classList.contains('lightbox') ||
            current.classList.contains('backdrop') ||
            current.classList.contains('overlay') ||
            current.getAttribute('role') === 'dialog' ||
            current.getAttribute('aria-modal') === 'true') {
            return true;
        }
        // Check for common modal patterns in class names
        const className = current.className.toLowerCase();
        if (className.includes('modal') ||
            className.includes('dialog') ||
            className.includes('popup') ||
            className.includes('overlay') ||
            className.includes('lightbox') ||
            className.includes('backdrop')) {
            return true;
        }
        // Check for elements that might be modals based on their styling
        if (position === 'fixed' && zIndex > 100) {
            return true;
        }
        current = current.parentElement;
    }
    return false;
}
// Helper function to check if extension context is valid
function isExtensionContextValid() {
    try {
        return typeof chrome !== 'undefined' &&
            typeof chrome.storage !== 'undefined' &&
            typeof chrome.storage.local !== 'undefined';
    }
    catch (e) {
        return false;
    }
}
// Safe wrapper to get runtime URL without throwing when context is invalidated
function safeGetURL(path) {
    var _a;
    try {
        if (typeof chrome !== 'undefined' && ((_a = chrome.runtime) === null || _a === void 0 ? void 0 : _a.getURL)) {
            return chrome.runtime.getURL(path);
        }
    }
    catch (_b) { }
    return path;
}
// Suppress unhandled promise rejections caused by extension context invalidation
try {
    window.addEventListener('unhandledrejection', (event) => {
        const msg = String(event.reason || '');
        if (msg.includes('Extension context invalidated')) {
            event.preventDefault();
        }
    });
}
catch (_a) { }
// Helper function to get data from storage with retry
function getStorageData() {
    return __awaiter(this, arguments, void 0, function* (retries = 3) {
        const empty = { passwords: [], cards: [], personalInfo: [], credentials: [], neverAskSites: [], pendingLoginData: null };
        for (let i = 0; i < retries; i++) {
            try {
                if (!isExtensionContextValid()) {
                    // Return empty dataset instead of throwing to avoid blocking autofill initialization
                    return empty;
                }
                // Also fetch legacy 'credentials' so we can use them for autofill
                const res = yield chrome.storage.local.get(['passwords', 'cards', 'personalInfo', 'credentials', 'neverAskSites', 'pendingLoginData']);
                //  console.log('Raw storage data retrieved:', res);
                // console.log('Storage keys found:', Object.keys(res));
                // console.log('Cards data:', res.cards);
                // console.log('Personal info data:', res.personalInfo);
                // console.log('Credentials data:', res.credentials);
                return {
                    passwords: Array.isArray(res.passwords) ? res.passwords : [],
                    cards: Array.isArray(res.cards) ? res.cards : [],
                    personalInfo: Array.isArray(res.personalInfo) ? res.personalInfo : [],
                    credentials: Array.isArray(res.credentials) ? res.credentials : [],
                    neverAskSites: Array.isArray(res.neverAskSites) ? res.neverAskSites : [],
                    pendingLoginData: res.pendingLoginData || null
                };
            }
            catch (error) {
                if (i === retries - 1)
                    return empty;
                yield new Promise(resolve => setTimeout(resolve, 500));
            }
        }
        return empty;
    });
}
// Cache for autofill data to avoid repeated storage calls
let autofillDataCache = null;
let lastCacheUpdate = 0;
const CACHE_DURATION = 5000; // 5 seconds cache
// Cache for favicon URLs to avoid repeated fetches
const faviconCache = new Map();
// Enhanced function to get storage data with caching
function getCachedStorageData() {
    return __awaiter(this, arguments, void 0, function* (forceRefresh = false) {
        const now = Date.now();
        // Return cached data if it's still valid and not forcing refresh
        if (!forceRefresh && autofillDataCache && (now - lastCacheUpdate) < CACHE_DURATION) {
            return autofillDataCache;
        }
        // Fetch fresh data from storage
        const freshData = yield getStorageData();
        // Update cache
        autofillDataCache = freshData;
        lastCacheUpdate = now;
        return freshData;
    });
}
// Function to refresh autofill data cache
function refreshAutofillDataCache() {
    autofillDataCache = null;
    lastCacheUpdate = 0;
    // console.log('Autofill data cache refreshed');
}
// Function to refresh autofill data for all active inputs
function refreshActiveInputsAutofill() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            // Get all currently focused or active inputs
            const activeInputs = document.querySelectorAll('input:focus, input[data-defendia-active="1"]');
            if (activeInputs.length > 0) {
                // console.log('Refreshing autofill for active inputs:', activeInputs.length);
                // Force refresh the cache
                const freshData = yield getCachedStorageData(true);
                // Update autofill suggestions for active inputs
                activeInputs.forEach((input) => __awaiter(this, void 0, void 0, function* () {
                    if (input instanceof HTMLInputElement) {
                        // Re-trigger autofill detection for this input
                        const event = new Event('focus', { bubbles: true });
                        input.dispatchEvent(event);
                    }
                }));
            }
        }
        catch (error) {
            console.error('Error refreshing active inputs autofill:', error);
        }
    });
}
// Storage change listener to refresh autofill data in real-time
function initializeStorageListener() {
    if (!window.__defendia_storage_listener_added) {
        try {
            chrome.storage.onChanged.addListener((changes, namespace) => {
                if (namespace === 'local') {
                    // Check if any autofill-relevant data changed
                    const relevantKeys = ['passwords', 'cards', 'personalInfo', 'credentials', 'neverAskSites'];
                    const hasRelevantChanges = relevantKeys.some(key => changes[key]);
                    if (hasRelevantChanges) {
                        // console.log('Storage changed, refreshing autofill data:', Object.keys(changes));
                        // Refresh the cache immediately
                        refreshAutofillDataCache();
                        // Refresh autofill for any active inputs
                        setTimeout(() => {
                            refreshActiveInputsAutofill();
                        }, 100);
                    }
                }
            });
            window.__defendia_storage_listener_added = true;
            // console.log('Storage change listener initialized');
        }
        catch (error) {
            console.error('Failed to initialize storage listener:', error);
        }
    }
}
// Function to sync autofill data with current storage
function syncAutofillDataWithStorage() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            // console.log('Syncing autofill data with storage...');
            // Force refresh cache
            const freshData = yield getCachedStorageData(true);
            // Update any existing popups
            const existingAutofillPopup = document.getElementById('autofill-popup');
            const existingPasswordGeneratorPopup = document.getElementById('password-generator-popup');
            if (existingAutofillPopup) {
                existingAutofillPopup.remove();
            }
            if (existingPasswordGeneratorPopup) {
                existingPasswordGeneratorPopup.remove();
            }
            // Mark all inputs as needing refresh
            const inputs = document.querySelectorAll('input');
            inputs.forEach(input => {
                if (input instanceof HTMLInputElement) {
                    input.setAttribute('data-defendia-needs-refresh', '1');
                }
            });
            // console.log('Autofill data synced with storage');
        }
        catch (error) {
            console.error('Error syncing autofill data:', error);
        }
    });
}
function detectInputFields() {
    // Include inputs within iframes (Stripe/Adyen style) when possible
    const inputs = document.querySelectorAll('input');
    inputs.forEach((input) => {
        // Skip button inputs and other non-text input types
        if (input.type === 'button' || input.type === 'submit' || input.type === 'reset' || input.type === 'file' || input.type === 'image') {
            return;
        }
        input.addEventListener('focus', () => __awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c, _d, _e, _f, _g;
            try {
                // console.log('Input focused:', {
                //   type: input.type,
                //   name: input.name,
                //   id: input.id,
                //   placeholder: input.placeholder,
                //   autocomplete: input.autocomplete
                // });
                // Check if extension context is valid
                if (!isExtensionContextValid()) {
                    // console.log('Extension context not valid, skipping autofill');
                    // console.log('Chrome object available:', typeof chrome !== 'undefined');
                    // console.log('Chrome storage available:', typeof chrome?.storage !== 'undefined');
                    // console.log('Chrome storage local available:', typeof chrome?.storage?.local !== 'undefined');
                    return;
                }
                // Suppress on OTP / verification code inputs
                const inputType = (input.type || '').toLowerCase();
                const inputName = (input.name || '').toLowerCase();
                const inputId = (input.id || '').toLowerCase();
                const inputPlaceholder = (input.placeholder || '').toLowerCase();
                const inputClass = (input.className || '').toLowerCase();
                const inputAc = (input.autocomplete || '').toLowerCase();
                const looksLikeOtpField = (() => {
                    // Common attributes indicating OTP fields
                    const otpHints = ['otp', 'one-time', 'one time', 'verification', 'verify', 'code', '2fa', 'twofactor', 'mfa', 'sms', 'email-code', 'emailcode', 'email_code'];
                    const hasOtpHint = otpHints.some(h => inputName.includes(h) || inputId.includes(h) || inputPlaceholder.includes(h) || inputClass.includes(h) || inputAc.includes(h));
                    const isOneCharBox = (input.maxLength === 1) || (input.getAttribute('maxlength') === '1');
                    const numericMode = (input.getAttribute('inputmode') || '').toLowerCase().includes('numeric') || inputType === 'tel';
                    // Grouped OTP boxes detection: multiple one-char inputs in the same form/container
                    let isGroupedOtp = false;
                    try {
                        const container = input.form || input.parentElement || document.body;
                        const oneCharInputs = Array.from(container.querySelectorAll('input'))
                            .filter((el) => (el.maxLength === 1 || el.getAttribute('maxlength') === '1'));
                        if (oneCharInputs.length >= 4 && oneCharInputs.length <= 8) {
                            isGroupedOtp = true;
                        }
                    }
                    catch (_a) { }
                    // Additional detection: Check for common verification code patterns in surrounding text
                    let hasVerificationContext = false;
                    try {
                        const form = input.closest('form');
                        const container = input.closest('div, section, article') || input.parentElement;
                        const contextText = ((form === null || form === void 0 ? void 0 : form.textContent) || (container === null || container === void 0 ? void 0 : container.textContent) || '').toLowerCase();
                        const verificationTexts = [
                            'check your email', 'enter the code', 'verification code', 'enter code',
                            'code sent to', 'enter verification', 'verify your', 'confirmation code',
                            'security code', 'access code', 'authentication code', 'enter the digits',
                            '6-digit code', '4-digit code', '5-digit code', '8-digit code'
                        ];
                        hasVerificationContext = verificationTexts.some(text => contextText.includes(text));
                    }
                    catch (_b) { }
                    // Check for common verification code field patterns
                    const isVerificationField = inputName.includes('verification') ||
                        inputName.includes('verify') ||
                        inputName.includes('code') ||
                        inputId.includes('verification') ||
                        inputId.includes('verify') ||
                        inputId.includes('code') ||
                        inputPlaceholder.includes('code') ||
                        inputPlaceholder.includes('verification') ||
                        inputPlaceholder.includes('verify');
                    return hasOtpHint || (isOneCharBox && numericMode) || isGroupedOtp || inputAc === 'one-time-code' || hasVerificationContext || isVerificationField;
                })();
                if (looksLikeOtpField) {
                    console.log('Defendia: OTP/Verification field detected, suppressing autofill:', {
                        inputName,
                        inputId,
                        inputPlaceholder,
                        inputType,
                        inputAc
                    });
                    removeAutofillPopup();
                    removePasswordGeneratorPopup();
                    return;
                }
                // Don't show autofill for fields that already have values
                if (input.value && input.value.trim().length > 0) {
                    removeAutofillPopup();
                    removePasswordGeneratorPopup();
                    return;
                }
                // Mark input as active for autofill refresh
                input.setAttribute('data-defendia-active', '1');
                const result = yield getCachedStorageData();
                // console.log('Storage data retrieved:', result);
                const suggestions = [];
                const fieldType = input.type.toLowerCase();
                const fieldName = ((_a = input.name) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
                const fieldId = ((_b = input.id) === null || _b === void 0 ? void 0 : _b.toLowerCase()) || '';
                const fieldPlaceholder = ((_c = input.placeholder) === null || _c === void 0 ? void 0 : _c.toLowerCase()) || '';
                const fieldClass = ((_d = input.className) === null || _d === void 0 ? void 0 : _d.toLowerCase()) || '';
                const ac = (input.autocomplete || '').toLowerCase();
                // Enhanced Google login detection
                const isGoogleLoginForm = () => {
                    var _a;
                    const form = input.closest('form');
                    const container = input.closest('div, section, article, main');
                    // Check for Google-specific indicators
                    const isGoogleDomain = window.location.hostname.includes('google.com') ||
                        window.location.hostname.includes('accounts.google.com') ||
                        window.location.hostname.includes('myaccount.google.com');
                    // Only check for Google-specific text if we're on a Google domain
                    if (!isGoogleDomain) {
                        return false;
                    }
                    // Check for Google-specific text content
                    const pageText = ((_a = document.body.textContent) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
                    const hasGoogleText = pageText.includes('sign in with google') ||
                        pageText.includes('use your google account') ||
                        pageText.includes('google account') ||
                        pageText.includes('sign in to google') ||
                        pageText.includes('continue with google');
                    // Check for Google-specific elements
                    const hasGoogleLogo = document.querySelector('[alt*="Google"], [src*="google"], [class*="google-logo"]') !== null;
                    const hasGoogleButton = document.querySelector('[class*="google"], [id*="google"], [data-provider*="google"]') !== null;
                    return isGoogleDomain && (hasGoogleText || hasGoogleLogo || hasGoogleButton);
                };
                // Check if we're in a login form context
                const isInLoginForm = () => {
                    var _a, _b, _c, _d, _e, _f, _g;
                    const form = input.closest('form');
                    if (!form) {
                        // Check if we're in a form-like container even without a proper form tag
                        const container = input.closest('[class*="form"], [class*="login"], [class*="signin"], [class*="auth"], [class*="google"], [role="form"]');
                        if (container) {
                            const hasPasswordField = container.querySelector('input[type="password"]') !== null;
                            const containerClass = ((_a = container.className) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
                            const containerId = ((_b = container.id) === null || _b === void 0 ? void 0 : _b.toLowerCase()) || '';
                            const containerText = ((_c = container.textContent) === null || _c === void 0 ? void 0 : _c.toLowerCase()) || '';
                            // Check if this is a checkout/billing form (not a login form)
                            const isCheckoutContext = containerText.includes('checkout') ||
                                containerText.includes('billing') ||
                                containerText.includes('shipping') ||
                                containerText.includes('payment') ||
                                containerText.includes('address') ||
                                containerClass.includes('checkout') ||
                                containerClass.includes('billing') ||
                                containerClass.includes('shipping') ||
                                containerClass.includes('payment') ||
                                containerId.includes('checkout') ||
                                containerId.includes('billing') ||
                                containerId.includes('shipping') ||
                                containerId.includes('payment');
                            // If it's a checkout context, don't treat as login form
                            if (isCheckoutContext) {
                                return false;
                            }
                            return hasPasswordField ||
                                containerClass.includes('login') ||
                                containerClass.includes('signin') ||
                                containerClass.includes('auth') ||
                                containerClass.includes('google') ||
                                containerId.includes('login') ||
                                containerId.includes('signin') ||
                                containerId.includes('auth') ||
                                containerId.includes('google') ||
                                isGoogleLoginForm();
                        }
                        return false;
                    }
                    // Check if form contains password field
                    const hasPasswordField = form.querySelector('input[type="password"]') !== null;
                    // Check if form has login-related attributes or content
                    const formAction = ((_d = form.action) === null || _d === void 0 ? void 0 : _d.toLowerCase()) || '';
                    const formClass = ((_e = form.className) === null || _e === void 0 ? void 0 : _e.toLowerCase()) || '';
                    const formId = ((_f = form.id) === null || _f === void 0 ? void 0 : _f.toLowerCase()) || '';
                    const formText = ((_g = form.textContent) === null || _g === void 0 ? void 0 : _g.toLowerCase()) || '';
                    // Check if this is a checkout/billing form (not a login form)
                    const isCheckoutContext = formText.includes('checkout') ||
                        formText.includes('billing') ||
                        formText.includes('shipping') ||
                        formText.includes('payment') ||
                        formText.includes('address') ||
                        formAction.includes('checkout') ||
                        formAction.includes('billing') ||
                        formAction.includes('shipping') ||
                        formAction.includes('payment') ||
                        formClass.includes('checkout') ||
                        formClass.includes('billing') ||
                        formClass.includes('shipping') ||
                        formClass.includes('payment') ||
                        formId.includes('checkout') ||
                        formId.includes('billing') ||
                        formId.includes('shipping') ||
                        formId.includes('payment');
                    // If it's a checkout context, don't treat as login form
                    if (isCheckoutContext) {
                        return false;
                    }
                    return hasPasswordField ||
                        formAction.includes('login') || formAction.includes('signin') || formAction.includes('auth') || formAction.includes('google') ||
                        formClass.includes('login') || formClass.includes('signin') || formClass.includes('auth') || formClass.includes('google') ||
                        formId.includes('login') || formId.includes('signin') || formId.includes('auth') || formId.includes('google') ||
                        isGoogleLoginForm();
                };
                // Enhanced field detection with priority to avoid conflicts
                // Check autocomplete attribute first as it's most reliable
                const hasCardAutocomplete = ac.startsWith('cc-') || ['cardnumber', 'card-number', 'ccnumber', 'cc-number'].includes(ac);
                const hasPersonalAutocomplete = ac.includes('email') ||
                    ac.includes('name') ||
                    ac.includes('given-name') ||
                    ac.includes('family-name') ||
                    ac.includes('address-line1') ||
                    ac.includes('address-line2') ||
                    ac.includes('street-address') ||
                    ac.includes('postal-code') ||
                    ac.includes('country') ||
                    ac.includes('organization') ||
                    ac.includes('tel');
                // Check for card-specific patterns
                const hasCardPatterns = fieldName.includes('card') || fieldName.includes('cc') || fieldName.includes('credit') || fieldName.includes('debit') ||
                    fieldId.includes('card') || fieldId.includes('cc') || fieldId.includes('credit') || fieldId.includes('debit') ||
                    fieldPlaceholder.includes('card') || fieldPlaceholder.includes('cc') || fieldPlaceholder.includes('credit') || fieldPlaceholder.includes('debit') ||
                    fieldName.includes('exp') || (fieldName.includes('date') && (fieldName.includes('exp') || fieldName.includes('expir'))) || fieldName.includes('expiry') || fieldName.includes('expiration') ||
                    fieldId.includes('exp') || (fieldId.includes('date') && (fieldId.includes('exp') || fieldId.includes('expir'))) || fieldId.includes('expiry') || fieldId.includes('expiration') ||
                    fieldPlaceholder.includes('exp') || (fieldPlaceholder.includes('date') && (fieldPlaceholder.includes('exp') || fieldPlaceholder.includes('expir'))) || fieldPlaceholder.includes('expiry') || fieldPlaceholder.includes('expiration') ||
                    fieldName.includes('cvv') || fieldName.includes('cvc') || fieldName.includes('security') || fieldName.includes('verification') ||
                    fieldId.includes('cvv') || fieldId.includes('cvc') || fieldId.includes('security') || fieldId.includes('verification') ||
                    fieldPlaceholder.includes('cvv') || fieldPlaceholder.includes('cvc') || fieldPlaceholder.includes('security') || fieldPlaceholder.includes('verification') ||
                    fieldName.includes('holder') || fieldName.includes('cardholder') ||
                    fieldId.includes('holder') || fieldId.includes('cardholder') ||
                    fieldPlaceholder.includes('holder') || fieldPlaceholder.includes('cardholder');
                // Additional check to exclude email/phone/username fields from being detected as card fields
                const isEmailOrPhoneField = fieldType === 'email' || fieldType === 'tel' ||
                    fieldName.includes('email') || fieldName.includes('mail') || fieldName.includes('phone') || fieldName.includes('tel') || fieldName.includes('username') || fieldName.includes('login') || fieldName.includes('account') ||
                    fieldId.includes('email') || fieldId.includes('mail') || fieldId.includes('phone') || fieldId.includes('tel') || fieldId.includes('username') || fieldId.includes('login') || fieldId.includes('account') ||
                    fieldPlaceholder.includes('email') || fieldPlaceholder.includes('mail') || fieldPlaceholder.includes('phone') || fieldPlaceholder.includes('tel') || fieldPlaceholder.includes('username') || fieldPlaceholder.includes('login') || fieldPlaceholder.includes('account') ||
                    ac.includes('email') || ac.includes('tel') || ac.includes('username') ||
                    // Special case for Apple ID fields
                    fieldId.includes('apple_id') || fieldId.includes('appleid') || fieldName.includes('apple_id') || fieldName.includes('appleid') ||
                    // Check aria-labelledby for Apple ID
                    (input.getAttribute('aria-labelledby') && input.getAttribute('aria-labelledby').includes('apple_id'));
                // Check for personal info patterns (excluding card-related ones)
                // Check for personal info patterns (excluding card-related ones and login-related ones)
                const hasPersonalPatterns =
                // Only include name-related patterns that are NOT in login forms
                (fieldName.includes('name') && !fieldName.includes('card') && !fieldName.includes('cc') && !fieldName.includes('user') && !fieldName.includes('login')) ||
                    (fieldName.includes('fullname') && !fieldName.includes('card')) ||
                    (fieldName.includes('full-name') && !fieldName.includes('card')) ||
                    (fieldName.includes('firstname') && !fieldName.includes('card')) ||
                    (fieldName.includes('lastname') && !fieldName.includes('card')) ||
                    (fieldId.includes('name') && !fieldId.includes('card') && !fieldId.includes('cc') && !fieldId.includes('user') && !fieldId.includes('login')) ||
                    (fieldId.includes('fullname') && !fieldId.includes('card')) ||
                    (fieldId.includes('full-name') && !fieldId.includes('card')) ||
                    (fieldId.includes('firstname') && !fieldId.includes('card')) ||
                    (fieldId.includes('lastname') && !fieldId.includes('card')) ||
                    (fieldPlaceholder.includes('name') && !fieldPlaceholder.includes('card')) ||
                    (fieldPlaceholder.includes('fullname') && !fieldPlaceholder.includes('card')) ||
                    (fieldPlaceholder.includes('full-name') && !fieldPlaceholder.includes('card')) ||
                    (fieldPlaceholder.includes('firstname') && !fieldPlaceholder.includes('card')) ||
                    (fieldPlaceholder.includes('lastname') && !fieldPlaceholder.includes('card')) ||
                    // Address and location fields
                    fieldName.includes('address') || fieldName.includes('street') || fieldName.includes('addr') || fieldName.includes('line1') || fieldName.includes('line2') ||
                    fieldId.includes('address') || fieldId.includes('street') || fieldId.includes('addr') || fieldId.includes('line1') || fieldId.includes('line2') ||
                    fieldPlaceholder.includes('address') || fieldPlaceholder.includes('street') || fieldPlaceholder.includes('addr') || fieldPlaceholder.includes('line1') || fieldPlaceholder.includes('line2') ||
                    fieldName.includes('city') || fieldName.includes('town') || fieldName.includes('municipality') ||
                    fieldId.includes('city') || fieldId.includes('town') || fieldId.includes('municipality') ||
                    fieldPlaceholder.includes('city') || fieldPlaceholder.includes('town') || fieldPlaceholder.includes('municipality') ||
                    fieldName.includes('state') || fieldName.includes('province') || fieldName.includes('region') || fieldName.includes('county') ||
                    fieldId.includes('state') || fieldId.includes('province') || fieldId.includes('region') || fieldId.includes('county') ||
                    fieldPlaceholder.includes('state') || fieldPlaceholder.includes('province') || fieldPlaceholder.includes('region') || fieldPlaceholder.includes('county') ||
                    fieldName.includes('zip') || fieldName.includes('postal') || fieldName.includes('postcode') || fieldName.includes('pincode') ||
                    fieldId.includes('zip') || fieldId.includes('postal') || fieldId.includes('postcode') || fieldId.includes('pincode') ||
                    fieldPlaceholder.includes('zip') || fieldPlaceholder.includes('postal') || fieldPlaceholder.includes('postcode') || fieldPlaceholder.includes('pincode') ||
                    fieldName.includes('country') || fieldName.includes('nation') ||
                    fieldId.includes('country') || fieldId.includes('nation') ||
                    fieldPlaceholder.includes('country') || fieldPlaceholder.includes('nation') ||
                    // Phone fields (but not in login forms)
                    (fieldName.includes('phone') && !fieldName.includes('user') && !fieldName.includes('login')) ||
                    (fieldName.includes('mobile') && !fieldName.includes('user') && !fieldName.includes('login')) ||
                    (fieldName.includes('tel') && !fieldName.includes('user') && !fieldName.includes('login')) ||
                    (fieldName.includes('telephone') && !fieldName.includes('user') && !fieldName.includes('login')) ||
                    (fieldName.includes('cell') && !fieldName.includes('user') && !fieldName.includes('login')) ||
                    (fieldId.includes('phone') && !fieldId.includes('user') && !fieldId.includes('login')) ||
                    (fieldId.includes('mobile') && !fieldId.includes('user') && !fieldId.includes('login')) ||
                    (fieldId.includes('tel') && !fieldId.includes('user') && !fieldId.includes('login')) ||
                    (fieldId.includes('telephone') && !fieldId.includes('user') && !fieldId.includes('login')) ||
                    (fieldId.includes('cell') && !fieldId.includes('user') && !fieldId.includes('login')) ||
                    (fieldPlaceholder.includes('phone') && !fieldPlaceholder.includes('user') && !fieldPlaceholder.includes('login')) ||
                    (fieldPlaceholder.includes('mobile') && !fieldPlaceholder.includes('user') && !fieldPlaceholder.includes('login')) ||
                    (fieldPlaceholder.includes('tel') && !fieldPlaceholder.includes('user') && !fieldPlaceholder.includes('login')) ||
                    (fieldPlaceholder.includes('telephone') && !fieldPlaceholder.includes('user') && !fieldPlaceholder.includes('login')) ||
                    (fieldPlaceholder.includes('cell') && !fieldPlaceholder.includes('user') && !fieldPlaceholder.includes('login')) ||
                    // Email fields for personal info (but not in login forms)
                    (fieldType === 'email' && !fieldName.includes('card') && !fieldId.includes('card') && !fieldPlaceholder.includes('card')) ||
                    (fieldName.includes('email') && !fieldName.includes('card') && !fieldName.includes('user') && !fieldName.includes('login')) ||
                    (fieldName.includes('mail') && !fieldName.includes('card') && !fieldName.includes('user') && !fieldName.includes('login')) ||
                    (fieldId.includes('email') && !fieldId.includes('card') && !fieldId.includes('user') && !fieldId.includes('login')) ||
                    (fieldId.includes('mail') && !fieldId.includes('card') && !fieldId.includes('user') && !fieldId.includes('login')) ||
                    (fieldPlaceholder.includes('email') && !fieldPlaceholder.includes('card') && !fieldPlaceholder.includes('user') && !fieldPlaceholder.includes('login')) ||
                    (fieldPlaceholder.includes('mail') && !fieldPlaceholder.includes('card') && !fieldPlaceholder.includes('user') && !fieldPlaceholder.includes('login'));
                // Check for username/password patterns (login forms)
                const hasLoginPatterns = fieldName.includes('user') || fieldName.includes('login') || fieldName.includes('account') ||
                    fieldId.includes('user') || fieldId.includes('login') || fieldId.includes('account') ||
                    fieldPlaceholder.includes('user') || fieldPlaceholder.includes('login') || fieldPlaceholder.includes('account') ||
                    ac.includes('username') || ac.includes('user') ||
                    // Email fields in login forms
                    (fieldType === 'email' && !fieldName.includes('card') && !fieldId.includes('card') && !fieldPlaceholder.includes('card')) ||
                    (fieldName.includes('email') && !fieldName.includes('card') && !fieldName.includes('address')) ||
                    (fieldId.includes('email') && !fieldId.includes('card') && !fieldId.includes('address')) ||
                    (fieldPlaceholder.includes('email') && !fieldPlaceholder.includes('card') && !fieldPlaceholder.includes('address'));
                // Determine field type with priority (card > personal > login > password)
                let isCardField = false;
                let isPersonalField = false;
                let isUsernameField = false;
                let isPasswordField = false;
                if (fieldType === 'password') {
                    isPasswordField = true;
                }
                else if (hasCardAutocomplete || (hasCardPatterns && !isEmailOrPhoneField)) {
                    isCardField = true;
                }
                else if (hasPersonalAutocomplete || hasPersonalPatterns) {
                    // In login forms, prioritize username detection over personal info
                    if (isInLoginForm() && (hasLoginPatterns || fieldType === 'email')) {
                        isUsernameField = true;
                    }
                    else {
                        isPersonalField = true;
                    }
                }
                else if (hasLoginPatterns || fieldType === 'email') {
                    isUsernameField = true;
                }
                else if (fieldType === 'text') {
                    // In login forms, default to username for generic text fields
                    if (isInLoginForm()) {
                        isUsernameField = true;
                    }
                    // Else, do not assume personal field without strong signals
                }
                // Additional context gating for personal info: require address/profile/checkout context
                const looksLikePersonalContext = () => {
                    try {
                        const form = input.closest('form');
                        const container = form || input.closest('section, article, main, div') || document.body;
                        const idCls = `${(container.id || '').toLowerCase()} ${(container.className || '').toLowerCase()}`;
                        const action = ((form === null || form === void 0 ? void 0 : form.action) || '').toLowerCase();
                        const text = (container.textContent || '').toLowerCase();
                        const keywords = ['checkout', 'shipping', 'billing', 'address', 'delivery', 'contact', 'profile', 'account', 'register', 'signup', 'sign up'];
                        const keywordHit = keywords.some(k => idCls.includes(k) || action.includes(k) || text.includes(k));
                        // Count presence of multiple related fields
                        const relatedSelectors = [
                            'input[autocomplete*="given-name" i]', 'input[autocomplete*="family-name" i]',
                            'input[autocomplete*="street-address" i]', 'input[name*="address" i]', 'input[id*="address" i]',
                            'input[name*="city" i]', 'input[id*="city" i]', 'input[name*="state" i]', 'input[id*="state" i]',
                            'input[name*="zip" i]', 'input[id*="zip" i]', 'input[name*="postal" i]', 'input[id*="postal" i]',
                            'input[name*="country" i]', 'input[id*="country" i]', 'input[name*="phone" i]', 'input[id*="phone" i]'
                        ];
                        const count = relatedSelectors.reduce((acc, sel) => acc + container.querySelectorAll(sel).length, 0);
                        return keywordHit || count >= 2;
                    }
                    catch (_a) {
                        return false;
                    }
                };
                // Only apply context gating for generic text fields, not for fields with clear personal patterns
                if (isPersonalField && !looksLikePersonalContext()) {
                    // Check if this is a generic text field without clear personal patterns
                    const hasClearPersonalPatterns = fieldName.includes('name') || fieldName.includes('email') || fieldName.includes('phone') || fieldName.includes('address') ||
                        fieldId.includes('name') || fieldId.includes('email') || fieldId.includes('phone') || fieldId.includes('address') ||
                        fieldPlaceholder.includes('name') || fieldPlaceholder.includes('email') || fieldPlaceholder.includes('phone') || fieldPlaceholder.includes('address') ||
                        ac.includes('name') || ac.includes('email') || ac.includes('tel') || ac.includes('address');
                    // Only disable personal field if it's a generic text field without clear patterns
                    if (!hasClearPersonalPatterns) {
                        isPersonalField = false;
                    }
                }
                // Only show popup for relevant field types
                if (!(isUsernameField || isPasswordField || isCardField || isPersonalField)) {
                    removeAutofillPopup();
                    removePasswordGeneratorPopup();
                    return;
                }
                // Exclude generic fields and search fields from personal info autofill
                if (isPersonalField) {
                    const fieldName = ((_e = input.name) === null || _e === void 0 ? void 0 : _e.toLowerCase()) || '';
                    const fieldId = ((_f = input.id) === null || _f === void 0 ? void 0 : _f.toLowerCase()) || '';
                    const fieldPlaceholder = ((_g = input.placeholder) === null || _g === void 0 ? void 0 : _g.toLowerCase()) || '';
                    // Check for search fields
                    if (fieldName.includes('search') || fieldName.includes('query') || fieldName.includes('q') ||
                        fieldId.includes('search') || fieldId.includes('query') || fieldId.includes('q') ||
                        fieldPlaceholder.includes('search') || fieldPlaceholder.includes('query') || fieldPlaceholder.includes('q')) {
                        // console.log('Search field detected, excluding from personal info autofill');
                        isPersonalField = false;
                    }
                    // Check for generic text fields with no personal context
                    if (fieldName === '' && fieldId === '' &&
                        (fieldPlaceholder === 'enter a value' || fieldPlaceholder === 'enter value' ||
                            fieldPlaceholder === 'type here' || fieldPlaceholder === 'input' ||
                            fieldPlaceholder === 'text' || fieldPlaceholder === '')) {
                        // console.log('Generic text field with no personal context detected, excluding from personal info autofill');
                        isPersonalField = false;
                    }
                    // Check for other generic text fields
                    if (fieldName.includes('comment') || fieldName.includes('message') || fieldName.includes('note') ||
                        fieldId.includes('comment') || fieldId.includes('message') || fieldId.includes('note') ||
                        fieldPlaceholder.includes('comment') || fieldPlaceholder.includes('message') || fieldPlaceholder.includes('note')) {
                        // console.log('Generic text field detected, excluding from personal info autofill');
                        isPersonalField = false;
                    }
                }
                // If no field type is detected after filtering, don't show popup
                if (!(isUsernameField || isPasswordField || isCardField || isPersonalField)) {
                    removeAutofillPopup();
                    removePasswordGeneratorPopup();
                    return;
                }
                // Debug logging
                // console.log('Field detection results:', {
                //   fieldType: input.type,
                //   fieldName: input.name,
                //   fieldId: input.id,
                //   fieldPlaceholder: input.placeholder,
                //   autocomplete: input.autocomplete,
                //   isUsernameField,
                //   isPasswordField,
                //   isCardField,
                //   isPersonalField,
                //   isInLoginForm: isInLoginForm(),
                //   suggestionsCount: suggestions.length,
                //   hasLoginPatterns,
                //   hasPersonalPatterns,
                //   hasCardPatterns
                // });
                // Additional safety check: ensure this is actually an input field that can receive text
                if (input.readOnly || input.disabled || input.type === 'button' || input.type === 'submit' || input.type === 'reset') {
                    removeAutofillPopup();
                    removePasswordGeneratorPopup();
                    return;
                }
                // Check if this is a signup form for autofill purposes (less strict than password generator)
                const isSignUpFormForAutofill = () => {
                    var _a;
                    const form = input.closest('form');
                    if (!form)
                        return false;
                    const formText = ((_a = form.textContent) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
                    const hasSignUpText = formText.includes('sign up') ||
                        formText.includes('signup') ||
                        formText.includes('register') ||
                        formText.includes('create account') ||
                        formText.includes('new account') ||
                        formText.includes('join') ||
                        formText.includes('signup') ||
                        formText.includes('registration');
                    const hasLoginText = formText.includes('sign in') ||
                        formText.includes('signin') ||
                        formText.includes('login') ||
                        formText.includes('log in') ||
                        formText.includes('sign in to') ||
                        formText.includes('login to') ||
                        formText.includes('access your account') ||
                        formText.includes('welcome back');
                    if (hasLoginText) {
                        return false;
                    }
                    const hasPasswordConfirm = form.querySelector('input[type="password"][name*="confirm"], input[type="password"][name*="reenter"], input[type="password"][name*="re-enter"], input[type="password"][id*="confirm"], input[type="password"][id*="reenter"], input[type="password"][id*="re-enter"]');
                    const isNewPassword = input.autocomplete === 'new-password';
                    const isCurrentPassword = input.autocomplete === 'current-password';
                    if (isCurrentPassword) {
                        return false;
                    }
                    const hasMultiplePasswordFields = form.querySelectorAll('input[type="password"]').length > 1;
                    const hasEmailField = form.querySelector('input[type="email"], input[name*="email"], input[id*="email"]');
                    const hasUsernameField = form.querySelector('input[name*="username"], input[id*="username"], input[name*="user"], input[id*="user"]');
                    const isLikelySignUp = hasSignUpText || hasPasswordConfirm || isNewPassword || (hasMultiplePasswordFields && (hasEmailField || hasUsernameField));
                    return isLikelySignUp;
                };
                // Check if this is a login form
                const isLoginForm = () => {
                    var _a;
                    const form = input.closest('form');
                    if (!form)
                        return false;
                    const formText = ((_a = form.textContent) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
                    const hasLoginText = formText.includes('sign in') ||
                        formText.includes('signin') ||
                        formText.includes('login') ||
                        formText.includes('log in') ||
                        formText.includes('sign in to') ||
                        formText.includes('login to') ||
                        formText.includes('access your account') ||
                        formText.includes('welcome back');
                    const isCurrentPassword = input.autocomplete === 'current-password';
                    return hasLoginText || isCurrentPassword;
                };
                // Add password suggestions if it's a username or password field
                if (isUsernameField || isPasswordField) {
                    // Don't show autofill for password fields in signup forms (but allow on login forms)
                    if (isPasswordField && isSignUpFormForAutofill()) {
                        removeAutofillPopup();
                        removePasswordGeneratorPopup();
                        return;
                    }
                    const passwords = [];
                    if (Array.isArray(result.passwords))
                        passwords.push(...result.passwords);
                    if (Array.isArray(result.credentials)) {
                        passwords.push(...result.credentials.map((c) => ({
                            title: c.title || c.url || 'Login',
                            login: c.username || c.login || c.email || '',
                            password: c.password || '',
                            websites: c.url ? [c.url] : []
                        })));
                    }
                    // Enhanced Google login detection for autofill
                    const isGoogleLoginForm = () => {
                        var _a;
                        const isGoogleDomain = window.location.hostname.includes('google.com') ||
                            window.location.hostname.includes('accounts.google.com') ||
                            window.location.hostname.includes('myaccount.google.com');
                        // Only check for Google-specific text if we're on a Google domain
                        if (!isGoogleDomain) {
                            return false;
                        }
                        const pageText = ((_a = document.body.textContent) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
                        const hasGoogleText = pageText.includes('sign in with google') ||
                            pageText.includes('use your google account') ||
                            pageText.includes('google account') ||
                            pageText.includes('sign in to google') ||
                            pageText.includes('continue with google');
                        const hasGoogleLogo = document.querySelector('[alt*="Google"], [src*="google"], [class*="google-logo"]') !== null;
                        const hasGoogleButton = document.querySelector('[class*="google"], [id*="google"], [data-provider*="google"]') !== null;
                        const result = isGoogleDomain && (hasGoogleText || hasGoogleLogo || hasGoogleButton);
                        // Debug logging for Google detection
                        if (isGoogleDomain) {
                            console.log('Defendia: Google domain detected:', window.location.hostname);
                        }
                        return result;
                    };
                    const isGoogleLogin = isGoogleLoginForm();
                    // Debug domain matching
                    const currentDomain = getCurrentDomain();
                    // console.log('Domain matching debug:', {
                    //   currentDomain,
                    //   passwordsCount: passwords.length,
                    //   passwordsWithWebsites: passwords.filter(p => Array.isArray(p.websites) && p.websites.length > 0).length,
                    //   isGoogleLogin: isGoogleLogin
                    // });
                    // Enhanced domain matching for Google logins
                    const matchingPasswords = passwords.filter((p) => {
                        // For Google logins, also check if the credential is marked as Google login
                        if (isGoogleLogin && p.isGoogleLogin) {
                            return true; // Show Google credentials on any Google login page
                        }
                        if (!Array.isArray(p.websites) || p.websites.length === 0) {
                            // console.log('Password without websites:', p);
                            return false;
                        }
                        const hasMatch = p.websites.some((url) => {
                            const matches = domainsMatch(url, currentDomain);
                            // console.log('Domain match check:', {
                            //   storedUrl: url,
                            //   currentDomain: currentDomain,
                            //   matches,
                            //   storedDomain: url.replace(/^https?:\/\//, '').replace(/\/.*$/, '').replace(/^www\./, ''),
                            //   currentDomainClean: currentDomain.replace(/^www\./, '')
                            // });
                            return matches;
                        });
                        return hasMatch;
                    });
                    // console.log('Domain matching results:', {
                    //   totalPasswords: passwords.length,
                    //   matchingPasswords: matchingPasswords.length,
                    //   currentDomain: currentDomain,
                    //   matchingCredentials: matchingPasswords.map(p => ({
                    //     username: p.login,
                    //     websites: p.websites
                    //   }))
                    // });
                    if (matchingPasswords.length > 0) {
                        suggestions.push(...matchingPasswords.map((p) => ({
                            type: 'password',
                            title: p.title,
                            username: p.login,
                            password: p.password,
                            note: p.note,
                            websites: p.websites, // Preserve the websites array for domain detection
                            isGoogleLogin: p.isGoogleLogin || false // Preserve Google login flag
                        })));
                    }
                    else {
                        // Only log once per domain to reduce console spam
                        if (!window.__defendia_logged_no_passwords) {
                            window.__defendia_logged_no_passwords = new Set();
                        }
                        if (!window.__defendia_logged_no_passwords.has(currentDomain)) {
                            console.log('No matching passwords found for domain:', currentDomain);
                            window.__defendia_logged_no_passwords.add(currentDomain);
                        }
                        // console.log('This means no saved credentials exist for this website');
                    }
                }
                // Add card suggestions if it's a card field - show on any website
                if (isCardField && result.cards && Array.isArray(result.cards)) {
                    // console.log('Card field detected, adding card suggestions:', result.cards.length);
                    // console.log('Card data structure:', result.cards);
                    suggestions.push(...result.cards.map((c) => ({
                        type: 'card',
                        title: c.title,
                        cardNumber: c.cardNumber,
                        cardHolderName: c.cardHolderName || c.cardholderName || '',
                        expirationDate: c.expirationDate,
                        cvv: c.cvv
                    })));
                }
                else if (isCardField) {
                    console.log('Card field detected but no card data available');
                    console.log('isCardField:', isCardField);
                    console.log('result.cards:', result.cards);
                    console.log('result.cards type:', typeof result.cards);
                    console.log('result.cards isArray:', Array.isArray(result.cards));
                    console.log('Full result object keys:', Object.keys(result));
                }
                // Add personal info suggestions if it's a personal field - but NOT in login forms
                if (isPersonalField && !isInLoginForm() && result.personalInfo && Array.isArray(result.personalInfo)) {
                    console.log('Personal field detected (not in login form), adding personal info suggestions:', result.personalInfo.length);
                    console.log('Personal info data structure:', result.personalInfo);
                    console.log('isPersonalField:', isPersonalField);
                    console.log('isInLoginForm():', isInLoginForm());
                    suggestions.push(...result.personalInfo.map((p) => {
                        console.log('Processing personal info item:', p);
                        const fn = p.firstName || '';
                        const ln = p.lastName || '';
                        const derivedFull = [fn, ln].filter(Boolean).join(' ');
                        const fullName = p.fullName || derivedFull;
                        const segments = (fullName || '').trim().split(/\s+/);
                        // Only use firstName/lastName if they're not empty, otherwise extract from fullName
                        const firstName = (fn && fn.trim()) ? fn : segments[0] || '';
                        const lastName = (ln && ln.trim()) ? ln : (segments.length > 1 ? segments.slice(1).join(' ') : '');
                        console.log('Mapped values:', { firstName, lastName, fullName, email: p.email, phone: p.phone });
                        const phoneNumber = p.phoneNumber || p.phone || '';
                        const addressLine1 = p.addressLine1 || p.address || '';
                        const addressLine2 = p.addressLine2 || '';
                        const city = p.city || '';
                        const state = p.stateOrRegion || p.state || '';
                        const zip = p.zipOrPostalCode || p.zipCode || p.zip || '';
                        const country = p.country || '';
                        const fullAddress = [addressLine1, addressLine2, city, state, zip, country].filter(Boolean).join(', ');
                        return {
                            type: 'personal',
                            title: p.title || fullName || 'Personal Info',
                            fullName,
                            firstName,
                            lastName,
                            email: p.email || '',
                            phoneNumber,
                            phone: p.phone || p.phoneNumber || '', // Add phone field for compatibility
                            address: fullAddress,
                            addressLine1,
                            addressLine2,
                            city,
                            state,
                            zip,
                            country
                        };
                    }));
                }
                else if (isPersonalField) {
                    if (isInLoginForm()) {
                        // Personal field detected but in login form - not showing personal info suggestions
                    }
                    else {
                        // Personal field detected but no personal info data available
                    }
                    // Debug logging removed for production
                }
                // Debug logging removed for production
                if (suggestions.length > 0) {
                    // For password fields, prioritize password generator over personal autofill
                    if (isPasswordField) {
                        // Don't show personal autofill for password fields
                        const nonPersonalSuggestions = suggestions.filter(s => s.type !== 'personal');
                        if (nonPersonalSuggestions.length > 0) {
                            showAutofillPopup(input, nonPersonalSuggestions, {
                                isCardField,
                                isPersonalField: false,
                                isUsernameField,
                                isPasswordField
                            });
                        }
                    }
                    else {
                        showAutofillPopup(input, suggestions, {
                            isCardField,
                            isPersonalField,
                            isUsernameField,
                            isPasswordField
                        });
                    }
                }
                else {
                    // console.log('No suggestions to show for current domain:', getCurrentDomain());
                    removeAutofillPopup();
                    removePasswordGeneratorPopup();
                }
            }
            catch (error) {
                console.error('Error in autofill:', error);
            }
        }));
    });
}
// Global popup management to prevent conflicts
let isPopupActive = false;
let popupCreationTimeout = null;
let lastPopupInput = null;
let popupCooldownTimeout = null;
let operationCount = 0;
let autofillJustCompleted = false;
const MAX_CONCURRENT_OPERATIONS = 3;
function showAutofillPopup(input, suggestions, fieldTypes) {
    // Prevent popup if autofill was just completed
    if (autofillJustCompleted) {
        return;
    }
    // Prevent too many concurrent operations
    if (operationCount >= MAX_CONCURRENT_OPERATIONS) {
        return;
    }
    // Prevent multiple popups from being created simultaneously
    if (isPopupActive) {
        return;
    }
    // Check if we're in cooldown period
    if (popupCooldownTimeout) {
        return;
    }
    // Increment operation count
    operationCount++;
    // Clear any pending popup creation
    if (popupCreationTimeout) {
        clearTimeout(popupCreationTimeout);
        popupCreationTimeout = null;
    }
    // Remove any existing popups first
    removeAutofillPopup();
    // Set active flag and track input
    isPopupActive = true;
    lastPopupInput = input;
    // Add cooldown to prevent rapid popup creation
    popupCooldownTimeout = setTimeout(() => {
        popupCooldownTimeout = null;
    }, 200); // 200ms cooldown between popups
    // Add debounce to prevent rapid popup creation
    popupCreationTimeout = setTimeout(() => {
        createAutofillPopup(input, suggestions, fieldTypes);
    }, 50);
}
function createAutofillPopup(input, suggestions, fieldTypes) {
    var _a, _b, _c, _d;
    // Get extension theme preference
    let isExtensionDarkMode = false;
    try {
        // Try to get theme from extension storage
        chrome.storage.sync.get(['isDarkMode'], (result) => {
            if (result.isDarkMode !== undefined) {
                isExtensionDarkMode = result.isDarkMode;
                // console.log('Extension theme detected:', isExtensionDarkMode ? 'Dark' : 'Light');
            }
        });
    }
    catch (error) {
        console.log('Could not access extension storage for theme, using system preference');
    }
    // Function to get extension theme synchronously
    const getExtensionTheme = () => {
        try {
            // Try to get from local storage first (cached from previous sync)
            const cachedTheme = localStorage.getItem('defendia_extension_theme');
            if (cachedTheme !== null) {
                return cachedTheme === 'dark';
            }
        }
        catch (error) {
            console.log('Could not access local storage for cached theme');
        }
        // Fallback to system preference
        return window.matchMedia('(prefers-color-scheme: dark)').matches;
    };
    // Get the current theme
    const isDarkMode = getExtensionTheme();
    // Update theme asynchronously and cache it
    try {
        if (chrome.storage && chrome.storage.sync) {
            chrome.storage.sync.get(['isDarkMode'], (result) => {
                if (result.isDarkMode !== undefined) {
                    const newTheme = result.isDarkMode;
                    // Cache the theme for future use
                    localStorage.setItem('defendia_extension_theme', newTheme ? 'dark' : 'light');
                    // console.log('Extension theme updated and cached:', newTheme ? 'Dark' : 'Light');
                }
            });
        }
    }
    catch (error) {
        console.log('Could not access extension storage for theme update');
    }
    // Filter suggestions to show only relevant ones for the current field type
    const fieldType = input.type.toLowerCase();
    const fieldName = ((_a = input.name) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
    const fieldId = ((_b = input.id) === null || _b === void 0 ? void 0 : _b.toLowerCase()) || '';
    const fieldPlaceholder = ((_c = input.placeholder) === null || _c === void 0 ? void 0 : _c.toLowerCase()) || '';
    const ac = (input.autocomplete || '').toLowerCase();
    // Use passed field types if available, otherwise determine field type using the same logic as detectInputFields
    let isCardField = false;
    let isPersonalField = false;
    let isUsernameField = false;
    let isPasswordField = false;
    if (fieldTypes) {
        // Use the field types passed from detectInputFields
        isCardField = fieldTypes.isCardField;
        isPersonalField = fieldTypes.isPersonalField;
        isUsernameField = fieldTypes.isUsernameField;
        isPasswordField = fieldTypes.isPasswordField;
    }
    else {
        // Fallback to field type detection logic
        // Check autocomplete attribute first as it's most reliable
        const hasCardAutocomplete = ac.startsWith('cc-') || ['cardnumber', 'card-number', 'ccnumber', 'cc-number'].includes(ac);
        const hasPersonalAutocomplete = ac.includes('email') || ac.includes('name') || ac.includes('tel') || ac.includes('street-address') || ac.includes('postal-code') || ac.includes('country');
        const hasCardPatterns = fieldName.includes('card') || fieldName.includes('cc') || fieldName.includes('credit') || fieldName.includes('debit') ||
            fieldId.includes('card') || fieldId.includes('cc') || fieldId.includes('credit') || fieldId.includes('debit') ||
            fieldPlaceholder.includes('card') || fieldPlaceholder.includes('cc') || fieldPlaceholder.includes('credit') || fieldPlaceholder.includes('debit') ||
            fieldName.includes('exp') || (fieldName.includes('date') && (fieldName.includes('exp') || fieldName.includes('expir'))) || fieldName.includes('expiry') || fieldName.includes('expiration') ||
            fieldId.includes('exp') || (fieldId.includes('date') && (fieldId.includes('exp') || fieldId.includes('expir'))) || fieldId.includes('expiry') || fieldId.includes('expiration') ||
            fieldPlaceholder.includes('exp') || (fieldPlaceholder.includes('date') && (fieldPlaceholder.includes('exp') || fieldPlaceholder.includes('expir'))) || fieldPlaceholder.includes('expiry') || fieldPlaceholder.includes('expiration') ||
            fieldName.includes('cvv') || fieldName.includes('cvc') || fieldName.includes('security') || fieldName.includes('verification') ||
            fieldId.includes('cvv') || fieldId.includes('cvc') || fieldName.includes('security') || fieldId.includes('verification') ||
            fieldPlaceholder.includes('cvv') || fieldPlaceholder.includes('cvc') || fieldPlaceholder.includes('security') || fieldPlaceholder.includes('verification') ||
            fieldName.includes('holder') || fieldName.includes('cardholder') ||
            fieldId.includes('holder') || fieldId.includes('cardholder') ||
            fieldPlaceholder.includes('holder') || fieldPlaceholder.includes('cardholder');
        // Additional check to exclude email/phone/username fields from being detected as card fields
        const isEmailOrPhoneField = fieldType === 'email' || fieldType === 'tel' ||
            fieldName.includes('email') || fieldName.includes('mail') || fieldName.includes('phone') || fieldName.includes('tel') || fieldName.includes('username') || fieldName.includes('login') || fieldName.includes('account') ||
            fieldId.includes('email') || fieldId.includes('mail') || fieldId.includes('phone') || fieldId.includes('tel') || fieldId.includes('username') || fieldId.includes('login') || fieldId.includes('account') ||
            fieldPlaceholder.includes('email') || fieldPlaceholder.includes('mail') || fieldPlaceholder.includes('phone') || fieldPlaceholder.includes('tel') || fieldPlaceholder.includes('username') || fieldPlaceholder.includes('login') || fieldPlaceholder.includes('account') ||
            ac.includes('email') || ac.includes('tel') || ac.includes('username') ||
            // Special case for Apple ID fields
            fieldId.includes('apple_id') || fieldId.includes('appleid') || fieldName.includes('apple_id') || fieldName.includes('appleid') ||
            // Check aria-labelledby for Apple ID
            (input.getAttribute('aria-labelledby') && input.getAttribute('aria-labelledby').includes('apple_id'));
        const hasPersonalPatterns = (fieldType === 'email') ||
            (fieldName.includes('email') && !fieldName.includes('card')) ||
            (fieldName.includes('mail') && !fieldName.includes('card')) ||
            (fieldName.includes('e-mail') && !fieldName.includes('card')) ||
            (fieldId.includes('email') && !fieldId.includes('card')) ||
            (fieldId.includes('mail') && !fieldId.includes('card')) ||
            (fieldId.includes('e-mail') && !fieldId.includes('card')) ||
            (fieldPlaceholder.includes('email') && !fieldPlaceholder.includes('card')) ||
            (fieldPlaceholder.includes('mail') && !fieldPlaceholder.includes('card')) ||
            (fieldPlaceholder.includes('e-mail') && !fieldPlaceholder.includes('card')) ||
            (fieldName.includes('name') && !fieldName.includes('card') && !fieldName.includes('cc')) ||
            (fieldName.includes('fullname') && !fieldName.includes('card')) ||
            (fieldName.includes('full-name') && !fieldName.includes('card')) ||
            (fieldName.includes('firstname') && !fieldName.includes('card')) ||
            (fieldName.includes('lastname') && !fieldName.includes('card')) ||
            (fieldId.includes('name') && !fieldId.includes('card') && !fieldId.includes('cc')) ||
            (fieldId.includes('fullname') && !fieldId.includes('card')) ||
            (fieldId.includes('full-name') && !fieldId.includes('card')) ||
            (fieldId.includes('firstname') && !fieldId.includes('card')) ||
            (fieldId.includes('lastname') && !fieldId.includes('card')) ||
            (fieldPlaceholder.includes('name') && !fieldPlaceholder.includes('card') && !fieldPlaceholder.includes('cc')) ||
            (fieldPlaceholder.includes('fullname') && !fieldPlaceholder.includes('card')) ||
            (fieldPlaceholder.includes('full-name') && !fieldPlaceholder.includes('card')) ||
            (fieldPlaceholder.includes('firstname') && !fieldPlaceholder.includes('card')) ||
            (fieldPlaceholder.includes('lastname') && !fieldPlaceholder.includes('card')) ||
            fieldName.includes('phone') || fieldName.includes('mobile') || fieldName.includes('tel') || fieldName.includes('telephone') || fieldName.includes('cell') ||
            fieldId.includes('phone') || fieldId.includes('mobile') || fieldId.includes('tel') || fieldId.includes('telephone') || fieldId.includes('cell') ||
            fieldPlaceholder.includes('phone') || fieldPlaceholder.includes('mobile') || fieldPlaceholder.includes('tel') || fieldPlaceholder.includes('telephone') || fieldPlaceholder.includes('cell') ||
            fieldName.includes('address') || fieldName.includes('street') || fieldId.includes('addr') || fieldName.includes('line1') || fieldName.includes('line2') ||
            fieldId.includes('address') || fieldId.includes('street') || fieldId.includes('addr') || fieldId.includes('line1') || fieldId.includes('line2') ||
            fieldPlaceholder.includes('address') || fieldPlaceholder.includes('street') || fieldPlaceholder.includes('addr') || fieldPlaceholder.includes('line1') || fieldPlaceholder.includes('line2') ||
            fieldName.includes('city') || fieldName.includes('town') || fieldName.includes('municipality') ||
            fieldId.includes('city') || fieldId.includes('town') || fieldId.includes('municipality') ||
            fieldPlaceholder.includes('city') || fieldPlaceholder.includes('town') || fieldPlaceholder.includes('municipality') ||
            fieldName.includes('state') || fieldName.includes('province') || fieldName.includes('region') || fieldName.includes('county') ||
            fieldId.includes('state') || fieldId.includes('province') || fieldId.includes('region') || fieldId.includes('county') ||
            fieldPlaceholder.includes('state') || fieldPlaceholder.includes('province') || fieldPlaceholder.includes('region') || fieldPlaceholder.includes('county') ||
            fieldName.includes('zip') || fieldName.includes('postal') || fieldName.includes('postcode') || fieldName.includes('pincode') ||
            fieldId.includes('zip') || fieldId.includes('postal') || fieldId.includes('postcode') || fieldId.includes('pincode') ||
            fieldPlaceholder.includes('zip') || fieldPlaceholder.includes('postal') || fieldPlaceholder.includes('postcode') || fieldPlaceholder.includes('pincode') ||
            fieldName.includes('country') || fieldName.includes('nation') ||
            fieldId.includes('country') || fieldId.includes('nation') ||
            fieldPlaceholder.includes('country') || fieldPlaceholder.includes('nation');
        const hasLoginPatterns = fieldName.includes('user') || fieldName.includes('login') || fieldName.includes('account') ||
            fieldId.includes('user') || fieldId.includes('login') || fieldId.includes('account') ||
            fieldPlaceholder.includes('user') || fieldPlaceholder.includes('login') || fieldPlaceholder.includes('account') ||
            ac.includes('username') || ac.includes('user');
        if (fieldType === 'password') {
            isPasswordField = true;
        }
        else if (hasCardAutocomplete || (hasCardPatterns && !isEmailOrPhoneField)) {
            isCardField = true;
        }
        else if (hasPersonalAutocomplete || hasPersonalPatterns) {
            isPersonalField = true;
        }
        else if (hasLoginPatterns || fieldType === 'email') {
            isUsernameField = true;
        }
        else if (fieldType === 'text') {
            isUsernameField = true;
        }
    }
    let filteredSuggestions = suggestions;
    if (isUsernameField || isPasswordField) {
        filteredSuggestions = suggestions.filter(s => s.type === 'password');
    }
    else if (isCardField) {
        filteredSuggestions = suggestions.filter(s => s.type === 'card');
    }
    else if (isPersonalField) {
        filteredSuggestions = suggestions.filter(s => s.type === 'personal');
    }
    console.log('showAutofillPopup filtering:', {
        originalSuggestions: suggestions.length,
        filteredSuggestions: filteredSuggestions.length,
        isUsernameField,
        isPasswordField,
        isCardField,
        isPersonalField,
        suggestions: suggestions.map(s => ({ type: s.type, title: s.title }))
    });
    if (filteredSuggestions.length === 0) {
        removePasswordGeneratorPopup();
        return;
    }
    const rect = input.getBoundingClientRect();
    const popup = document.createElement('div');
    popup.id = 'autofill-popup';
    const insideModal = isInsideModal(input);
    console.log('Modal detection:', {
        insideModal,
        inputElement: input,
        inputClasses: input.className,
        inputParent: (_d = input.parentElement) === null || _d === void 0 ? void 0 : _d.className
    });
    if (insideModal) {
        popup.style.position = 'fixed';
        popup.style.transform = 'translateZ(0)';
        // Use viewport coordinates for modal inputs
        popup.style.top = `${rect.bottom}px`;
        popup.style.left = `${rect.left}px`;
    }
    else {
        popup.style.position = 'absolute';
        // Use document coordinates for normal inputs
        popup.style.top = `${rect.bottom + window.scrollY}px`;
        popup.style.left = `${rect.left + window.scrollX}px`;
    }
    popup.style.width = `${Math.max(rect.width, 350)}px`;
    // Original styling with modal fixes
    popup.style.background = isDarkMode ? '#1A1A1A' : '#FFFFFF';
    popup.style.border = isDarkMode ? '1px solid #444444' : '1px solid #E0E0E0';
    popup.style.borderRadius = '12px';
    popup.style.boxShadow = isDarkMode
        ? '0 8px 32px rgba(0, 0, 0, 0.6), 0 2px 8px rgba(0, 0, 0, 0.3)'
        : '0 8px 32px rgba(0, 0, 0, 0.15), 0 2px 8px rgba(0, 0, 0, 0.1)';
    popup.style.zIndex = '2147483647'; // Maximum z-index to appear above all modals
    popup.style.fontSize = '14px';
    popup.style.fontFamily = 'system-ui, -apple-system, BlinkMacSystemFont, sans-serif';
    popup.style.padding = '16px 0';
    popup.style.maxHeight = 'none';
    popup.style.overflowY = 'visible';
    popup.style.backdropFilter = 'blur(10px)';
    popup.style.border = isDarkMode ? '1px solid #333333' : '1px solid #E5E5E5';
    const header = document.createElement('div');
    header.style.padding = '0 16px 16px 16px';
    header.style.borderBottom = isDarkMode ? '1px solid #333333' : '1px solid #E5E5E5';
    header.style.marginBottom = '8px';
    // console.log('Popup title debug:', {
    //   isCardField,
    //   isPersonalField,
    //   isUsernameField,
    //   isPasswordField,
    //   fieldType: input.type,
    //   fieldName: input.name,
    //   fieldId: input.id
    // });
    const title = document.createElement('div');
    title.textContent = getPopupTitleForFieldType(isCardField, isPersonalField, isUsernameField, isPasswordField);
    title.style.fontWeight = '600';
    title.style.fontSize = '16px';
    title.style.color = isDarkMode ? '#FFFFFF' : '#1A1A1A';
    title.style.textAlign = 'start';
    title.style.letterSpacing = '-0.01em';
    header.appendChild(title);
    popup.appendChild(header);
    filteredSuggestions.forEach((suggestion, index) => {
        // console.log('Creating autofill option:', {
        //   suggestion,
        //   type: suggestion.type,
        //   websites: suggestion.websites,
        //   username: suggestion.username,
        //   title: suggestion.title
        // });
        const option = document.createElement('div');
        option.style.padding = '12px 16px';
        option.style.cursor = 'pointer';
        option.style.transition = 'all 0.2s ease';
        option.style.color = isDarkMode ? '#FFFFFF' : '#1A1A1A';
        option.style.display = 'flex';
        option.style.alignItems = 'center';
        option.style.gap = '12px';
        option.style.borderRadius = '8px';
        option.style.margin = '0 8px 4px 8px';
        option.style.border = isDarkMode ? '1px solid transparent' : '1px solid transparent';
        option.addEventListener('mouseenter', () => {
            option.style.backgroundColor = isDarkMode ? '#2A2A2A' : '#F8F9FA';
            option.style.border = isDarkMode ? '1px solid #444444' : '1px solid #E1E5E9';
            option.style.transform = 'translateY(-1px)';
        });
        option.addEventListener('mouseleave', () => {
            option.style.backgroundColor = 'transparent';
            option.style.border = '1px solid transparent';
            option.style.transform = 'translateY(0)';
        });
        const iconContainer = document.createElement('div');
        iconContainer.style.width = '32px';
        iconContainer.style.height = '32px';
        iconContainer.style.borderRadius = '6px';
        iconContainer.style.display = 'flex';
        iconContainer.style.alignItems = 'center';
        iconContainer.style.justifyContent = 'center';
        iconContainer.style.flexShrink = '0';
        iconContainer.style.border = '1px solid rgba(0, 0, 0, 0.1)';
        const domainIcon = getDomainIconForSuggestion(suggestion);
        // console.log('Domain icon for suggestion:', {
        //   suggestion,
        //   domainIcon,
        //   type: suggestion.type,
        //   websites: suggestion.websites
        // });
        if (domainIcon) {
            iconContainer.style.background = domainIcon.background;
            if (domainIcon.faviconUrl && suggestion.type === 'password') {
                const faviconImg = document.createElement('img');
                faviconImg.style.width = '20px';
                faviconImg.style.height = '20px';
                faviconImg.style.borderRadius = '4px';
                faviconImg.style.objectFit = 'contain';
                const faviconPromise = getFaviconUrl(domainIcon.faviconUrl);
                if (typeof faviconPromise === 'string') {
                    faviconImg.src = faviconPromise;
                }
                else {
                    faviconPromise.then((faviconUrl) => {
                        faviconImg.src = faviconUrl;
                        faviconImg.onerror = () => {
                            setSafeHTML(iconContainer, domainIcon.svg);
                        };
                    }).catch(() => {
                        setSafeHTML(iconContainer, domainIcon.svg);
                    });
                }
                iconContainer.innerHTML = '';
                iconContainer.appendChild(faviconImg);
            }
            else {
                setSafeHTML(iconContainer, domainIcon.svg);
            }
        }
        else {
            if (suggestion.type === 'password') {
                iconContainer.style.background = '#FF6B6B';
                setSafeHTML(iconContainer, '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM9 6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9V6zm3 11c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z" fill="white"/></svg>');
            }
            else if (suggestion.type === 'card') {
                iconContainer.style.background = '#4ECDC4';
                setSafeHTML(iconContainer, '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zm0 14H4v-6h16v6zm0-10H4V6h16v2z" fill="white"/></svg>');
            }
            else if (suggestion.type === 'personal') {
                iconContainer.style.background = '#45B7D1';
                setSafeHTML(iconContainer, '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z" fill="white"/></svg>');
            }
        }
        option.appendChild(iconContainer);
        const content = document.createElement('div');
        content.style.flex = '1';
        content.style.minWidth = '0';
        const primaryText = document.createElement('div');
        primaryText.textContent = getPrimaryTextForType(suggestion);
        primaryText.style.fontWeight = '500';
        primaryText.style.fontSize = '14px';
        primaryText.style.color = isDarkMode ? '#FFFFFF' : '#1A1A1A';
        primaryText.style.marginBottom = '2px';
        primaryText.style.overflow = 'hidden';
        primaryText.style.textOverflow = 'ellipsis';
        primaryText.style.whiteSpace = 'nowrap';
        primaryText.style.letterSpacing = '-0.01em';
        content.appendChild(primaryText);
        const secondaryText = document.createElement('div');
        secondaryText.textContent = getSecondaryTextForType(suggestion);
        secondaryText.style.fontSize = '12px';
        secondaryText.style.color = isDarkMode ? '#B0B0B0' : '#6B7280';
        secondaryText.style.overflow = 'hidden';
        secondaryText.style.textOverflow = 'ellipsis';
        secondaryText.style.whiteSpace = 'nowrap';
        secondaryText.style.letterSpacing = '0.01em';
        content.appendChild(secondaryText);
        option.appendChild(content);
        if (index === 0) {
            const moreIcon = document.createElement('div');
            moreIcon.style.width = '24px';
            moreIcon.style.height = '24px';
            moreIcon.style.borderRadius = '50%';
            moreIcon.style.background = isDarkMode ? '#333333' : '#F1F3F4';
            moreIcon.style.display = 'flex';
            moreIcon.style.alignItems = 'center';
            moreIcon.style.justifyContent = 'center';
            moreIcon.style.flexShrink = '0';
            moreIcon.style.transition = 'all 0.2s ease';
            setSafeHTML(moreIcon, '<svg width="12" height="12" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z" fill="currentColor"/>');
            moreIcon.style.color = isDarkMode ? '#B0B0B0' : '#6B7280';
            moreIcon.addEventListener('mouseenter', () => {
                moreIcon.style.background = isDarkMode ? '#444444' : '#E5E7EB';
                moreIcon.style.transform = 'scale(1.1)';
            });
            moreIcon.addEventListener('mouseleave', () => {
                moreIcon.style.background = isDarkMode ? '#333333' : '#F1F3F4';
                moreIcon.style.transform = 'scale(1)';
            });
            option.appendChild(moreIcon);
        }
        option.addEventListener('click', (e) => {
            e.preventDefault();
            e.stopPropagation();
            // IMMEDIATELY close popup - no delays
            removeAutofillPopup();
            // Force remove any existing popup elements
            const existingPopup = document.getElementById('autofill-popup');
            if (existingPopup) {
                existingPopup.remove();
            }
            // Clear any pending popup creation
            if (popupCreationTimeout) {
                clearTimeout(popupCreationTimeout);
                popupCreationTimeout = null;
            }
            // Reset all popup flags immediately
            isPopupActive = false;
            lastPopupInput = null;
            autofillJustCompleted = true;
            if (operationCount > 0) {
                operationCount--;
            }
            // Fill the data after popup is closed
            setTimeout(() => {
                autofillData(input, suggestion);
            }, 10);
            // Reset autofill completion flag after a delay
            setTimeout(() => {
                autofillJustCompleted = false;
            }, 1000); // 1 second delay
            // Multiple fallbacks to ensure popup is closed
            setTimeout(() => {
                const lingeringPopup = document.getElementById('autofill-popup');
                if (lingeringPopup) {
                    lingeringPopup.remove();
                }
            }, 50);
            setTimeout(() => {
                const lingeringPopup = document.getElementById('autofill-popup');
                if (lingeringPopup) {
                    lingeringPopup.remove();
                }
            }, 100);
            setTimeout(() => {
                const lingeringPopup = document.getElementById('autofill-popup');
                if (lingeringPopup) {
                    lingeringPopup.remove();
                }
            }, 200);
        });
        popup.appendChild(option);
    });
    document.body.appendChild(popup);
    // Auto-close popup after 10 seconds to prevent page stuck issues
    const autoCloseTimeout = setTimeout(() => {
        removeAutofillPopup();
    }, 10000);
    // Reposition and auto-close bindings
    const margin = 8;
    const clamp = (val, min, max) => Math.max(min, Math.min(max, val));
    const reposition = () => {
        try {
            const r = input.getBoundingClientRect();
            const topBelow = r.bottom + window.scrollY;
            // Check if input is inside a modal
            const insideModal = isInsideModal(input);
            let top, left;
            const width = Math.max(r.width, 350);
            if (insideModal) {
                // Position popup outside modal - use viewport coordinates (no scroll offset)
                top = r.bottom;
                left = r.left;
                // Ensure popup doesn't go off-screen
                const maxLeft = window.innerWidth - width - margin;
                const adjustedLeft = Math.max(margin, Math.min(left, maxLeft));
                // Check if popup would be cut off at bottom and adjust
                const popupHeight = popup.offsetHeight || 200; // Estimate height if not available
                const maxTop = window.innerHeight - popupHeight - margin;
                const adjustedTop = Math.min(top, maxTop);
                popup.style.top = `${adjustedTop}px`;
                popup.style.left = `${adjustedLeft}px`;
                popup.style.position = 'fixed'; // Use fixed positioning to escape modal boundaries
                popup.style.transform = 'translateZ(0)'; // Force hardware acceleration
                popup.style.zIndex = '2147483647'; // Ensure maximum z-index
            }
            else {
                // Normal positioning for non-modal inputs
                top = topBelow;
                const leftRaw = r.left + window.scrollX;
                left = clamp(leftRaw, window.scrollX + margin, window.scrollX + window.innerWidth - width - margin);
                popup.style.top = `${top}px`;
                popup.style.left = `${left}px`;
                popup.style.position = 'absolute';
            }
            popup.style.width = `${width}px`;
            // Remove maxHeight constraint to allow full content display
            popup.style.maxHeight = 'none';
        }
        catch (_a) { }
    };
    const onScroll = () => reposition();
    const onResize = () => reposition();
    window.addEventListener('scroll', onScroll, true);
    window.addEventListener('resize', onResize);
    reposition();
    const inputListener = () => {
        try {
            const val = (input.value || '').trim();
            if (val.length > 0) {
                removeAutofillPopup();
                removePasswordGeneratorPopup();
            }
        }
        catch (_a) { }
    };
    input.addEventListener('input', inputListener);
    input.addEventListener('change', inputListener);
    const clickAway = (e) => {
        const target = e.target;
        if (!popup.contains(target) && target !== input && !popup.contains(target)) {
            console.log('Click outside detected, closing popup...');
            removeAutofillPopup();
            removePasswordGeneratorPopup();
            document.removeEventListener('click', clickAway);
        }
    };
    setTimeout(() => document.addEventListener('click', clickAway), 10);
    const handleEscape = (e) => {
        if (e.key === 'Escape') {
            removeAutofillPopup();
            removePasswordGeneratorPopup();
            document.removeEventListener('keydown', handleEscape);
        }
    };
    document.addEventListener('keydown', handleEscape);
    // Save cleanup on node for safe removal
    popup.cleanup = () => {
        try {
            window.removeEventListener('scroll', onScroll, true);
        }
        catch (_a) { }
        try {
            window.removeEventListener('resize', onResize);
        }
        catch (_b) { }
        try {
            input.removeEventListener('input', inputListener);
        }
        catch (_c) { }
        try {
            input.removeEventListener('change', inputListener);
        }
        catch (_d) { }
        try {
            document.removeEventListener('click', clickAway);
        }
        catch (_e) { }
        try {
            document.removeEventListener('keydown', handleEscape);
        }
        catch (_f) { }
        try {
            clearTimeout(autoCloseTimeout);
        }
        catch (_g) { }
    };
}
function getIconForType(type) {
    switch (type) {
        case 'password':
            return '🔑';
        case 'card':
            return '💳';
        case 'personal':
            return '👤';
        default:
            return '📝';
    }
}
function getPrimaryTextForType(suggestion) {
    switch (suggestion.type) {
        case 'password':
            return suggestion.username || suggestion.login || suggestion.email || 'No username';
        case 'card':
            return suggestion.title || suggestion.cardHolderName || 'Credit Card';
        case 'personal':
            return suggestion.email || suggestion.fullName || suggestion.title || 'Personal Information';
        default:
            return suggestion.title || 'Unknown';
    }
}
function getSecondaryTextForType(suggestion) {
    switch (suggestion.type) {
        case 'password':
            if (suggestion.websites && suggestion.websites.length > 0) {
                try {
                    const url = new URL(suggestion.websites[0]);
                    return url.hostname.replace(/^www\./, '');
                }
                catch (_a) {
                    const urlStr = suggestion.websites[0];
                    if (urlStr && typeof urlStr === 'string') {
                        const domain = urlStr.replace(/^https?:\/\//, '').replace(/\/.*$/, '').replace(/^www\./, '');
                        return domain || 'Unknown domain';
                    }
                    return 'Unknown domain';
                }
            }
            return getCurrentDomain().replace(/^www\./, '') || 'Unknown domain';
        case 'card':
            const maskedNumber = suggestion.cardNumber ?
                `•••• ${suggestion.cardNumber.slice(-4)}` : 'No card number';
            return `${suggestion.cardHolderName || 'Unknown'} • ${maskedNumber}`;
        case 'personal':
            if (suggestion.email) {
                try {
                    const domain = suggestion.email.split('@')[1];
                    return domain || 'Unknown domain';
                }
                catch (_b) {
                    return 'Unknown domain';
                }
            }
            return suggestion.fullName || 'Personal information';
        default:
            return '';
    }
}
function getSubtitleForType(suggestion) {
    switch (suggestion.type) {
        case 'password':
            return suggestion.username || 'No username';
        case 'card':
            const maskedNumber = suggestion.cardNumber ?
                `•••• ${suggestion.cardNumber.slice(-4)}` : 'No card number';
            return `${suggestion.cardHolderName || 'Unknown'} • ${maskedNumber}`;
        case 'personal':
            return suggestion.email || suggestion.fullName || 'Personal information';
        default:
            return '';
    }
}
// Optimized field detection helper
function matchesField(field, patterns) {
    const fieldName = (field.name || '').toLowerCase();
    const fieldId = (field.id || '').toLowerCase();
    const fieldPlaceholder = (field.placeholder || '').toLowerCase();
    const fieldClass = (field.className || '').toLowerCase();
    const ac = (field.autocomplete || '').toLowerCase();
    return patterns.some(pattern => fieldName.includes(pattern) ||
        fieldId.includes(pattern) ||
        fieldPlaceholder.includes(pattern) ||
        fieldClass.includes(pattern) ||
        ac.includes(pattern));
}
function setElementValue(el, value) {
    try {
        // Guard unsupported inputs
        if (el.tagName !== 'INPUT' ||
            el.type === 'button' ||
            el.type === 'submit' ||
            el.type === 'reset' ||
            el.type === 'file' ||
            el.type === 'image' ||
            el.disabled) {
            console.log('setElementValue: Input not supported or disabled');
            return;
        }
        const wasReadOnly = !!el.readOnly;
        if (wasReadOnly) {
            try {
                el.readOnly = false;
            }
            catch (_a) { }
        }
        try {
            el.focus({ preventScroll: true });
        }
        catch (_b) {
            try {
                el.focus();
            }
            catch (_c) { }
        }
        // Use the native setter so frameworks (React, Vue, Angular) notice the change
        const descriptor = Object.getOwnPropertyDescriptor(Object.getPrototypeOf(el), 'value') ||
            Object.getOwnPropertyDescriptor(HTMLInputElement.prototype, 'value');
        if (descriptor && descriptor.set) {
            descriptor.set.call(el, value);
        }
        else {
            el.value = value;
        }
        // Sync the attribute for sites reading attributes instead of properties
        try {
            el.setAttribute('value', value);
        }
        catch (_d) { }
        // Dispatch events that most frameworks listen to
        const eventInit = { bubbles: true, composed: true };
        try {
            el.dispatchEvent(new InputEvent('input', Object.assign(Object.assign({}, eventInit), { data: value })));
        }
        catch (_e) {
            el.dispatchEvent(new Event('input', eventInit));
        }
        try {
            el.dispatchEvent(new Event('change', eventInit));
        }
        catch (_f) { }
        try {
            el.dispatchEvent(new Event('blur', eventInit));
        }
        catch (_g) { }
        if (wasReadOnly) {
            try {
                el.readOnly = true;
            }
            catch (_h) { }
        }
    }
    catch (error) {
        // Best-effort fallback assignment
        if (el.tagName === 'INPUT' &&
            el.type !== 'button' &&
            el.type !== 'submit' &&
            el.type !== 'reset' &&
            el.type !== 'file' &&
            el.type !== 'image' &&
            !el.disabled) {
            el.value = value;
        }
    }
    // Mark as auto-filled for later logic
    try {
        el.dataset = el.dataset || {};
        el.dataset.defendiaFilled = '1';
        setTimeout(() => {
            const clear = () => { try {
                delete el.dataset.defendiaFilled;
            }
            catch (_a) { } };
            el.addEventListener('input', clear, { once: true });
            el.addEventListener('keydown', clear, { once: true });
            el.addEventListener('paste', clear, { once: true });
        }, 0);
    }
    catch (_j) { }
}
function autofillData(input, suggestion, onComplete) {
    var _a;
    const form = input.form;
    if (!form) {
        onComplete === null || onComplete === void 0 ? void 0 : onComplete();
        return;
    }
    // console.log('Autofilling data:', {
    //   suggestionType: suggestion.type,
    //   fieldType: input.type,
    //   fieldName: input.name,
    //   fieldId: input.id
    // });
    // Remove any existing Defendia icons from input fields
    const existingIcon = (_a = input.parentElement) === null || _a === void 0 ? void 0 : _a.querySelector('[data-defendia-icon]');
    if (existingIcon) {
        existingIcon.remove();
    }
    // Add input field icon indicator with robust positioning
    const iconWrapper = document.createElement('div');
    iconWrapper.setAttribute('data-defendia-icon', 'true');
    iconWrapper.style.cssText = `
    position: absolute;
    right: 12px;
    top: 50%;
    transform: translateY(-50%);
    pointer-events: none;
    z-index: 1000;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 6px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    /* Force positioning to work on all sites */
    position: absolute !important;
    z-index: 9999 !important;
  `;
    try {
        const icon = document.createElement('img');
        icon.src = safeGetURL('icons/icon_input.svg');
        icon.style.cssText = `
      width: 30px;
      height: 30px;
      opacity: 0.8;
    `;
        iconWrapper.appendChild(icon);
    }
    catch (_b) { }
    // Create a more robust positioning system that works on all websites
    const inputParent = input.parentElement;
    if (inputParent) {
        // Force positioning context
        inputParent.style.position = 'relative';
        inputParent.style.overflow = 'visible';
        // Create a wrapper div specifically for the icon to ensure proper positioning
        const iconContainer = document.createElement('div');
        iconContainer.style.cssText = `
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      pointer-events: none;
      z-index: 999;
    `;
        // Move icon to the container
        iconContainer.appendChild(iconWrapper);
        inputParent.appendChild(iconContainer);
        // Add padding to input to make space for icon inside the field
        input.style.paddingRight = '50px';
        input.style.position = 'relative';
        input.style.zIndex = '1';
        // Force the input to be the positioning context
        input.style.position = 'relative';
    }
    // Icon stays visible permanently - no timeout removal
    const inputs = form.querySelectorAll('input');
    inputs.forEach((field) => {
        var _a, _b, _c, _d;
        if (field.tagName !== 'INPUT' || field.type === 'button' || field.type === 'submit' || field.type === 'reset') {
            return;
        }
        const fieldType = field.type.toLowerCase();
        const fieldName = ((_a = field.name) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
        const fieldId = ((_b = field.id) === null || _b === void 0 ? void 0 : _b.toLowerCase()) || '';
        const fieldPlaceholder = ((_c = field.placeholder) === null || _c === void 0 ? void 0 : _c.toLowerCase()) || '';
        const fieldClass = ((_d = field.className) === null || _d === void 0 ? void 0 : _d.toLowerCase()) || '';
        const ac = (field.autocomplete || '').toLowerCase();
        switch (suggestion.type) {
            case 'password':
                if (fieldType === 'text' || fieldType === 'email' ||
                    fieldName.includes('username') || fieldName.includes('email') || fieldName.includes('login') || fieldName.includes('user') || fieldName.includes('account') ||
                    fieldId.includes('username') || fieldId.includes('email') || fieldId.includes('login') || fieldId.includes('user') || fieldId.includes('account') ||
                    fieldPlaceholder.includes('email') || fieldPlaceholder.includes('username') || fieldPlaceholder.includes('login') || fieldPlaceholder.includes('user') || fieldPlaceholder.includes('account') ||
                    fieldClass.includes('username') || fieldClass.includes('email') || fieldClass.includes('login') || fieldClass.includes('user') ||
                    ac.includes('username') || ac.includes('email') || ac.includes('user')) {
                    setElementValue(field, suggestion.username);
                }
                else if (fieldType === 'password' ||
                    fieldName.includes('password') || fieldName.includes('pass') || fieldName.includes('pwd') ||
                    fieldId.includes('password') || fieldId.includes('pass') || fieldId.includes('pwd') ||
                    fieldPlaceholder.includes('password') || fieldPlaceholder.includes('pass') || fieldPlaceholder.includes('pwd') ||
                    fieldClass.includes('password') || fieldClass.includes('pass') || fieldClass.includes('pwd') ||
                    ac.includes('password') || ac.includes('current-password') || ac.includes('new-password')) {
                    setElementValue(field, suggestion.password);
                }
                break;
            case 'card': {
                // Optimized field detection for card autofill
                const nameHint = ac === 'cc-name' || fieldName.includes('name') || fieldName.includes('holder') || fieldName.includes('cardholder') ||
                    fieldId.includes('name') || fieldId.includes('holder') || fieldId.includes('cardholder') ||
                    fieldPlaceholder.includes('name') || fieldPlaceholder.includes('holder') || fieldPlaceholder.includes('cardholder') ||
                    fieldClass.includes('name') || fieldClass.includes('holder') || fieldClass.includes('cardholder');
                const expHint = ac === 'cc-exp' || fieldName.includes('exp') || (fieldName.includes('date') && (fieldName.includes('exp') || fieldName.includes('expir'))) || fieldName.includes('expiration') ||
                    fieldId.includes('exp') || (fieldId.includes('date') && (fieldId.includes('exp') || fieldId.includes('expir'))) || fieldId.includes('expiration') ||
                    fieldPlaceholder.includes('exp') || (fieldPlaceholder.includes('date') && (fieldPlaceholder.includes('exp') || fieldPlaceholder.includes('expir'))) || fieldPlaceholder.includes('expiration') ||
                    fieldClass.includes('exp') || fieldClass.includes('date') || fieldClass.includes('expiration');
                const cvvHint = ac === 'cc-csc' ||
                    (fieldName.includes('cvv') && !fieldName.includes('zip') && !fieldName.includes('postal')) ||
                    (fieldName.includes('cvc') && !fieldName.includes('zip') && !fieldName.includes('postal')) ||
                    (fieldName.includes('security') && !fieldName.includes('zip') && !fieldName.includes('postal')) ||
                    (fieldName.includes('code') && !fieldName.includes('zip') && !fieldName.includes('postal')) ||
                    fieldId.includes('cvv') || fieldId.includes('cvc') ||
                    (fieldId.includes('security') && !fieldId.includes('zip') && !fieldId.includes('postal')) ||
                    (fieldId.includes('code') && !fieldId.includes('zip') && !fieldId.includes('postal')) ||
                    fieldPlaceholder.includes('cvv') || fieldPlaceholder.includes('cvc') ||
                    (fieldPlaceholder.includes('security') && !fieldPlaceholder.includes('zip') && !fieldPlaceholder.includes('postal')) ||
                    (fieldPlaceholder.includes('code') && !fieldPlaceholder.includes('zip') && !fieldPlaceholder.includes('postal')) ||
                    fieldClass.includes('cvv') || fieldClass.includes('cvc') ||
                    (fieldClass.includes('security') && !fieldClass.includes('zip') && !fieldClass.includes('postal')) ||
                    (fieldClass.includes('code') && !fieldClass.includes('zip') && !fieldClass.includes('postal'));
                const numberHint = ac === 'cc-number' ||
                    fieldName.includes('number') || fieldName.includes('cardnumber') || fieldName.includes('ccnumber') || fieldName.includes('card') ||
                    fieldId.includes('number') || fieldId.includes('cardnumber') || fieldId.includes('ccnumber') || fieldId.includes('card') ||
                    fieldPlaceholder.includes('number') || fieldPlaceholder.includes('card number') || fieldPlaceholder.includes('card') ||
                    fieldClass.includes('number') || fieldClass.includes('cardnumber') || fieldClass.includes('ccnumber') || fieldClass.includes('card');
                // Specific detection for postal/zip code fields
                const postalHint = ac === 'postal-code' || ac === 'postal' ||
                    fieldName.includes('zip') || fieldName.includes('postal') || fieldName.includes('postcode') || fieldName.includes('pincode') ||
                    fieldId.includes('zip') || fieldId.includes('postal') || fieldId.includes('postcode') || fieldId.includes('pincode') ||
                    fieldPlaceholder.includes('zip') || fieldPlaceholder.includes('postal') || fieldPlaceholder.includes('postcode') || fieldPlaceholder.includes('pincode') ||
                    fieldClass.includes('zip') || fieldClass.includes('postal') || fieldClass.includes('postcode') || fieldClass.includes('pincode');
                if (nameHint) {
                    setElementValue(field, suggestion.cardHolderName || '');
                }
                else if (expHint) {
                    setElementValue(field, suggestion.expirationDate || '');
                }
                else if (cvvHint) {
                    setElementValue(field, suggestion.cvv || '');
                }
                else if (numberHint) {
                    setElementValue(field, suggestion.cardNumber || '');
                }
                else if (postalHint) {
                    setElementValue(field, suggestion.zipCode || suggestion.zip || '');
                }
                break;
            }
            case 'personal':
                // Enhanced personal info field detection
                console.log('Personal autofill - Field details:', {
                    fieldType,
                    fieldName,
                    fieldId,
                    fieldPlaceholder,
                    fieldClass,
                    ac,
                    suggestion: suggestion
                });
                console.log('Available suggestion data:', {
                    firstName: suggestion.firstName,
                    lastName: suggestion.lastName,
                    fullName: suggestion.fullName,
                    email: suggestion.email,
                    phone: suggestion.phone,
                    phoneNumber: suggestion.phoneNumber
                });
                // Debug: Check if we're processing the right fields
                console.log('Current field being processed:', {
                    tagName: field.tagName,
                    type: fieldType,
                    name: fieldName,
                    id: fieldId,
                    placeholder: fieldPlaceholder,
                    autocomplete: ac
                });
                if (ac === 'name' || ac === 'full-name' || fieldName.includes('fullname') || fieldName.includes('full-name') ||
                    fieldId.includes('fullname') || fieldId.includes('full-name') ||
                    fieldPlaceholder.includes('fullname') || fieldPlaceholder.includes('full-name') ||
                    fieldClass.includes('fullname') || fieldClass.includes('full-name')) {
                    setElementValue(field, suggestion.fullName || [suggestion.firstName, suggestion.lastName].filter(Boolean).join(' '));
                }
                else if (ac === 'given-name' || fieldName.includes('first') || fieldName.includes('firstname') ||
                    fieldId.includes('first') || fieldId.includes('firstname') ||
                    fieldPlaceholder.includes('first') || fieldPlaceholder.includes('firstname') ||
                    fieldClass.includes('first') || fieldClass.includes('firstname')) {
                    // Extract first name from fullName if firstName is empty
                    let firstName = suggestion.firstName || '';
                    if (!firstName && suggestion.fullName) {
                        const nameParts = suggestion.fullName.trim().split(/\s+/);
                        firstName = nameParts[0] || '';
                    }
                    setElementValue(field, firstName);
                }
                // Additional patterns for first name
                else if (fieldName === 'firstname' || fieldId === 'firstname' ||
                    fieldName === 'first_name' || fieldId === 'first_name' ||
                    fieldName === 'firstName' || fieldId === 'firstName') {
                    // Extract first name from fullName if firstName is empty
                    let firstName = suggestion.firstName || '';
                    if (!firstName && suggestion.fullName) {
                        const nameParts = suggestion.fullName.trim().split(/\s+/);
                        firstName = nameParts[0] || '';
                    }
                    setElementValue(field, firstName);
                }
                else if (ac === 'additional-name' || fieldName.includes('middle') || fieldName.includes('middlename') ||
                    fieldId.includes('middle') || fieldId.includes('middlename') ||
                    fieldPlaceholder.includes('middle') || fieldPlaceholder.includes('middlename') ||
                    fieldClass.includes('middle') || fieldClass.includes('middlename')) {
                }
                else if (ac === 'family-name' || fieldName.includes('last') || fieldName.includes('surname') || fieldName.includes('lastname') ||
                    fieldId.includes('last') || fieldId.includes('surname') || fieldId.includes('lastname') ||
                    fieldPlaceholder.includes('last') || fieldPlaceholder.includes('surname') || fieldPlaceholder.includes('lastname') ||
                    fieldClass.includes('last') || fieldClass.includes('surname') || fieldClass.includes('lastname')) {
                    // Extract last name from fullName if lastName is empty
                    let lastName = suggestion.lastName || '';
                    if (!lastName && suggestion.fullName) {
                        const nameParts = suggestion.fullName.trim().split(/\s+/);
                        lastName = nameParts.length > 1 ? nameParts.slice(1).join(' ') : '';
                    }
                    setElementValue(field, lastName);
                }
                // Additional patterns for last name
                else if (fieldName === 'lastname' || fieldId === 'lastname' ||
                    fieldName === 'last_name' || fieldId === 'last_name' ||
                    fieldName === 'lastName' || fieldId === 'lastName') {
                    // Extract last name from fullName if lastName is empty
                    let lastName = suggestion.lastName || '';
                    if (!lastName && suggestion.fullName) {
                        const nameParts = suggestion.fullName.trim().split(/\s+/);
                        lastName = nameParts.length > 1 ? nameParts.slice(1).join(' ') : '';
                    }
                    setElementValue(field, lastName);
                }
                else if (fieldType === 'email' || ac.includes('email') || fieldName.includes('email') || fieldName.includes('mail') || fieldName.includes('e-mail') ||
                    fieldId.includes('email') || fieldId.includes('mail') || fieldId.includes('e-mail') ||
                    fieldPlaceholder.includes('email') || fieldPlaceholder.includes('mail') || fieldPlaceholder.includes('e-mail') ||
                    fieldClass.includes('email') || fieldClass.includes('mail')) {
                    setElementValue(field, suggestion.email || '');
                }
                else if (ac.startsWith('tel') || fieldName.includes('phone') || fieldName.includes('mobile') || fieldName.includes('tel') || fieldName.includes('telephone') ||
                    fieldId.includes('phone') || fieldId.includes('mobile') || fieldId.includes('tel') || fieldId.includes('telephone') ||
                    fieldPlaceholder.includes('phone') || fieldPlaceholder.includes('mobile') || fieldPlaceholder.includes('tel') ||
                    fieldClass.includes('phone') || fieldClass.includes('mobile') || fieldClass.includes('tel')) {
                    // Use phone or phoneNumber field from suggestion
                    const phoneValue = suggestion.phone || suggestion.phoneNumber || '';
                    setElementValue(field, phoneValue);
                }
                // Additional patterns for phone
                else if (fieldName === 'phone' || fieldId === 'phone' ||
                    fieldName === 'phoneNumber' || fieldId === 'phoneNumber' ||
                    fieldName === 'phone_number' || fieldId === 'phone_number') {
                    // Use phone or phoneNumber field from suggestion
                    const phoneValue = suggestion.phone || suggestion.phoneNumber || '';
                    setElementValue(field, phoneValue);
                }
                else if (ac === 'street-address' || fieldName.includes('address') || fieldName.includes('street') || fieldName.includes('addr') ||
                    fieldId.includes('address') || fieldId.includes('street') || fieldId.includes('addr') ||
                    fieldPlaceholder.includes('address') || fieldPlaceholder.includes('street') || fieldPlaceholder.includes('addr') ||
                    fieldClass.includes('address') || fieldClass.includes('street')) {
                    setElementValue(field, suggestion.address || '');
                }
                else if (ac === 'address-line1' || fieldName.includes('address1') || fieldName.includes('line1') || fieldName.includes('address1') ||
                    fieldId.includes('address1') || fieldId.includes('line1') ||
                    fieldPlaceholder.includes('address1') || fieldPlaceholder.includes('line1') ||
                    fieldClass.includes('address1') || fieldClass.includes('line1')) {
                    setElementValue(field, suggestion.addressLine1 || '');
                }
                else if (ac === 'address-line2' || fieldName.includes('address2') || fieldName.includes('line2') || fieldName.includes('address2') ||
                    fieldId.includes('address2') || fieldId.includes('line2') ||
                    fieldPlaceholder.includes('address2') || fieldPlaceholder.includes('line2') ||
                    fieldClass.includes('address2') || fieldClass.includes('line2')) {
                    setElementValue(field, suggestion.addressLine2 || '');
                }
                else if (ac === 'address-level2' || fieldName.includes('city') || fieldId.includes('city') ||
                    fieldPlaceholder.includes('city') || fieldClass.includes('city')) {
                    setElementValue(field, suggestion.city || '');
                }
                else if (ac === 'address-level1' || fieldName.includes('state') || fieldName.includes('region') || fieldName.includes('province') ||
                    fieldId.includes('state') || fieldId.includes('region') || fieldId.includes('province') ||
                    fieldPlaceholder.includes('state') || fieldPlaceholder.includes('region') || fieldPlaceholder.includes('province') ||
                    fieldClass.includes('state') || fieldClass.includes('region')) {
                    setElementValue(field, suggestion.state || '');
                }
                else if (ac === 'postal-code' || fieldName.includes('zip') || fieldName.includes('postal') || fieldName.includes('zipcode') ||
                    fieldId.includes('zip') || fieldId.includes('postal') || fieldId.includes('zipcode') ||
                    fieldPlaceholder.includes('zip') || fieldPlaceholder.includes('postal') || fieldPlaceholder.includes('zipcode') ||
                    fieldClass.includes('zip') || fieldClass.includes('postal') || fieldClass.includes('zipcode')) {
                    setElementValue(field, suggestion.zip || '');
                }
                else if (ac === 'country' || ac === 'country-name' || fieldName.includes('country') || fieldId.includes('country') ||
                    fieldPlaceholder.includes('country') || fieldClass.includes('country')) {
                    setElementValue(field, suggestion.country || '');
                }
                // Fallback: if no specific pattern matches, try to match by field position or common patterns
                else {
                    console.log('No specific pattern matched, trying fallback logic');
                    console.log('Field not matched:', {
                        fieldType,
                        fieldName,
                        fieldId,
                        fieldPlaceholder,
                        ac
                    });
                    // Aggressive fallback matching based on field names and IDs
                    if (fieldName === 'firstName' || fieldId === 'firstName' ||
                        fieldName === 'first_name' || fieldId === 'first_name' ||
                        fieldName === 'firstname' || fieldId === 'firstname' ||
                        fieldName.includes('first') || fieldId.includes('first') ||
                        fieldPlaceholder.includes('first') || fieldPlaceholder.includes('name') ||
                        // Match by placeholder text for forms without name/id
                        (fieldPlaceholder === 'john' && fieldType === 'text') ||
                        (fieldPlaceholder.includes('john') && fieldType === 'text')) {
                        const firstName = suggestion.firstName || (suggestion.fullName || '').split(/\s+/)[0] || '';
                        setElementValue(field, firstName);
                    }
                    else if (fieldName === 'lastName' || fieldId === 'lastName' ||
                        fieldName === 'last_name' || fieldId === 'last_name' ||
                        fieldName === 'lastname' || fieldId === 'lastname' ||
                        fieldName.includes('last') || fieldId.includes('last') ||
                        fieldPlaceholder.includes('last') || fieldPlaceholder.includes('surname') ||
                        // Match by placeholder text for forms without name/id
                        (fieldPlaceholder === 'doe' && fieldType === 'text') ||
                        (fieldPlaceholder.includes('doe') && fieldType === 'text')) {
                        const fullNameParts = (suggestion.fullName || '').split(/\s+/);
                        const lastName = suggestion.lastName || (fullNameParts.length > 1 ? fullNameParts.slice(1).join(' ') : '');
                        setElementValue(field, lastName);
                    }
                    else if (fieldName === 'phone' || fieldId === 'phone' ||
                        fieldName === 'phoneNumber' || fieldId === 'phoneNumber' ||
                        fieldName === 'phone_number' || fieldId === 'phone_number' ||
                        fieldName.includes('phone') || fieldId.includes('phone') ||
                        fieldName.includes('tel') || fieldId.includes('tel') ||
                        fieldPlaceholder.includes('phone') || fieldPlaceholder.includes('tel') ||
                        // Match by placeholder text for forms without name/id
                        (fieldPlaceholder === '070-123 45 67' && fieldType === 'tel') ||
                        (fieldPlaceholder.includes('070-123') && fieldType === 'tel') ||
                        (fieldType === 'tel' && fieldPlaceholder.includes('phone')) ||
                        (fieldType === 'tel' && fieldPlaceholder.includes('number'))) {
                        const phoneValue = suggestion.phone || suggestion.phoneNumber || '';
                        setElementValue(field, phoneValue);
                    }
                    else if (fieldName === 'email' || fieldId === 'email' || fieldType === 'email') {
                        setElementValue(field, suggestion.email || '');
                    }
                    // Position-based matching for forms without name/id attributes
                    else {
                        const allInputs = Array.from(form.querySelectorAll('input[type="text"], input[type="email"], input[type="tel"]'));
                        const currentIndex = allInputs.indexOf(field);
                        // Email is usually first (index 0)
                        if (currentIndex === 0 && fieldType === 'email') {
                            setElementValue(field, suggestion.email || '');
                        }
                        // First name is usually second (index 1)
                        else if (currentIndex === 1 && fieldType === 'text') {
                            const firstName = suggestion.firstName || (suggestion.fullName || '').split(/\s+/)[0] || '';
                            setElementValue(field, firstName);
                        }
                        // Last name is usually third (index 2)
                        else if (currentIndex === 2 && fieldType === 'text') {
                            const fullNameParts = (suggestion.fullName || '').split(/\s+/);
                            const lastName = suggestion.lastName || (fullNameParts.length > 1 ? fullNameParts.slice(1).join(' ') : '');
                            setElementValue(field, lastName);
                        }
                        // Phone is usually fourth (index 3)
                        else if (currentIndex === 3 && fieldType === 'tel') {
                            const phoneValue = suggestion.phone || suggestion.phoneNumber || '';
                            setElementValue(field, phoneValue);
                        }
                    }
                }
                break;
        }
    });
    // Call completion callback
    onComplete === null || onComplete === void 0 ? void 0 : onComplete();
    // Add event listener to close popup if user starts typing
    const closeOnInput = () => {
        removeAutofillPopup();
        input.removeEventListener('input', closeOnInput);
        input.removeEventListener('keydown', closeOnInput);
    };
    // Listen for user input to close popup
    input.addEventListener('input', closeOnInput, { once: true });
    input.addEventListener('keydown', closeOnInput, { once: true });
}
function removeAutofillPopup() {
    // Reset active flag first to allow new popups
    isPopupActive = false;
    lastPopupInput = null;
    // Decrement operation count
    if (operationCount > 0) {
        operationCount--;
    }
    // Clear any pending popup creation
    if (popupCreationTimeout) {
        clearTimeout(popupCreationTimeout);
        popupCreationTimeout = null;
    }
    // Clear cooldown timeout
    if (popupCooldownTimeout) {
        clearTimeout(popupCooldownTimeout);
        popupCooldownTimeout = null;
    }
    // Force remove all popup elements
    const popups = document.querySelectorAll('#autofill-popup');
    popups.forEach(popup => {
        var _a, _b;
        try {
            (_b = (_a = popup).cleanup) === null || _b === void 0 ? void 0 : _b.call(_a);
        }
        catch (e) {
            // Silent cleanup
        }
        try {
            popup.remove();
        }
        catch (e) {
            // Force remove if normal remove fails
            if (popup.parentNode) {
                popup.parentNode.removeChild(popup);
            }
        }
    });
    // Additional cleanup - remove any popup elements by class or id
    const allPopups = document.querySelectorAll('[id*="autofill"], [class*="autofill"]');
    allPopups.forEach(popup => {
        if (popup.id === 'autofill-popup' || popup.classList.contains('autofill-popup')) {
            try {
                popup.remove();
            }
            catch (e) {
                // Silent cleanup
            }
        }
    });
}
function removePasswordGeneratorPopup() {
    var _a, _b;
    const existingPopup = document.getElementById('password-generator-popup');
    if (existingPopup) {
        try {
            (_b = (_a = existingPopup).cleanup) === null || _b === void 0 ? void 0 : _b.call(_a);
        }
        catch (_c) { }
        existingPopup.remove();
    }
    // Clear the tracking variable and timeout
    currentPasswordGeneratorInput = null;
    if (passwordGeneratorTimeout) {
        clearTimeout(passwordGeneratorTimeout);
        passwordGeneratorTimeout = null;
    }
}
// Global cleanup function to prevent page stuck issues
function cleanupAllPopups() {
    removeAutofillPopup();
    removePasswordGeneratorPopup();
    // Remove any remaining popups
    const allPopups = document.querySelectorAll('[id*="popup"], [id*="autofill"], [id*="password"]');
    allPopups.forEach(popup => {
        var _a, _b;
        try {
            (_b = (_a = popup).cleanup) === null || _b === void 0 ? void 0 : _b.call(_a);
            popup.remove();
        }
        catch (e) {
            // Silent cleanup
        }
    });
    // Clear any remaining event listeners
    document.removeEventListener('click', () => { });
    document.removeEventListener('keydown', () => { });
    window.removeEventListener('scroll', () => { });
    window.removeEventListener('resize', () => { });
}
// Add cleanup on page unload
window.addEventListener('beforeunload', cleanupAllPopups);
window.addEventListener('unload', cleanupAllPopups);
// Global click handler to prevent popup conflicts
document.addEventListener('click', (e) => {
    const target = e.target;
    // If clicking on an input field, ensure we close any existing popup first
    if (target.tagName === 'INPUT' && target !== lastPopupInput) {
        if (isPopupActive) {
            removeAutofillPopup();
        }
    }
    // If clicking outside of popup area, close popup
    if (isPopupActive && !target.closest('#autofill-popup') && target.tagName !== 'INPUT') {
        removeAutofillPopup();
    }
});
// Performance monitor to prevent website freezing
let performanceCheckInterval = null;
function startPerformanceMonitor() {
    if (performanceCheckInterval) {
        clearInterval(performanceCheckInterval);
    }
    performanceCheckInterval = setInterval(() => {
        // If too many operations are running, force cleanup
        if (operationCount > MAX_CONCURRENT_OPERATIONS) {
            cleanupAllPopups();
            operationCount = 0;
        }
        // Check if popup has been active too long
        if (isPopupActive && lastPopupInput) {
            const popup = document.getElementById('autofill-popup');
            if (!popup) {
                // Popup was removed but flags weren't reset
                isPopupActive = false;
                lastPopupInput = null;
                operationCount = Math.max(0, operationCount - 1);
            }
        }
    }, 1000); // Check every second
}
// Start performance monitor
startPerformanceMonitor();
// Prevent multiple instances of content script
if (window.__defendia_content_script_initialized) {
    // Content script already initialized
}
else {
    window.__defendia_content_script_initialized = true;
    // Initialize the content script
    detectInputFields();
    detectPasswordFields();
    detectForms();
    initializeStorageListener();
}
// Listen for URL changes to refresh domain detection (useful for SPAs)
let lastUrl = location.href;
const urlObserver = new MutationObserver(() => {
    if (location.href !== lastUrl) {
        lastUrl = location.href;
        // console.log('URL changed, new domain:', getCurrentDomain());
        removeAutofillPopup();
        removePasswordGeneratorPopup();
    }
});
urlObserver.observe(document.body, {
    childList: true,
    subtree: true
});
let currentTheme = null;
function updateThemeFromExtension() {
    try {
        chrome.storage.sync.get(['isDarkMode'], (result) => {
            if (result.isDarkMode !== undefined && result.isDarkMode !== currentTheme) {
                currentTheme = result.isDarkMode;
                // console.log('Theme changed to:', currentTheme ? 'Dark' : 'Light');
                const existingAutofillPopup = document.getElementById('autofill-popup');
                if (existingAutofillPopup) {
                    removeAutofillPopup();
                }
                // Don't remove password generator popup on theme change - it's temporary and user-controlled
            }
        });
    }
    catch (error) {
        console.log('Could not access extension storage for theme updates');
    }
}
// Only run theme updates every 30 seconds to minimize interference
setInterval(updateThemeFromExtension, 30000);
// Test function to manually trigger save popup (for debugging)
window.testSavePopup = () => {
    console.log('Testing save popup...');
    const testPayload = {
        type: 'password',
        formData: {
            username: 'test@example.com',
            password: 'testpassword123',
            email: 'test@example.com',
            title: 'Test Site (example.com)'
        },
        domain: 'https://example.com'
    };
    chrome.runtime.sendMessage({ type: 'PROMPT_SAVE_DATA', payload: testPayload }, (response) => {
        console.log('Test message sent, response:', response);
    });
};
updateThemeFromExtension();
const observer = new MutationObserver(() => {
    detectInputFields();
    detectPasswordFields();
});
observer.observe(document.body, {
    childList: true,
    subtree: true
});
// Enhanced getFaviconUrl function for both current page and external domains
function getFaviconUrl(domain) {
    if (!domain) {
        const links = document.querySelectorAll('link[rel~="icon"]');
        if (links.length) {
            return links[0].href;
        }
        return `${location.origin}/favicon.ico`;
    }
    return getFaviconUrlForDomain(domain);
}
function getFaviconUrlForDomain(domain) {
    return __awaiter(this, void 0, void 0, function* () {
        if (faviconCache.has(domain)) {
            return faviconCache.get(domain);
        }
        try {
            const faviconUrl = `https://${domain}/favicon.ico`;
            const response = yield fetch(faviconUrl, {
                method: 'HEAD',
                mode: 'no-cors'
            });
            if (response.ok || response.status === 0) {
                faviconCache.set(domain, faviconUrl);
                return faviconUrl;
            }
        }
        catch (error) {
            console.log('Failed to fetch favicon for domain:', domain, error);
        }
        const googleFaviconUrl = `https://www.google.com/s2/favicons?domain=${domain}&sz=32`;
        faviconCache.set(domain, googleFaviconUrl);
        return googleFaviconUrl;
    });
}
// Enhanced form detection for modern websites
function detectForms() {
    // console.log('Initializing enhanced form detection for:', window.location.hostname);
    const isInIframe = window !== window.top;
    if (isInIframe) {
        console.log('Content script running in iframe, using enhanced detection methods');
    }
    // Method 1: Traditional form submit events
    if (!window.__defendia_submit_listener_added) {
        document.addEventListener('submit', handleFormSubmission, true);
        window.__defendia_submit_listener_added = true;
    }
    // Method 2: MutationObserver for dynamically added forms
    if (!window.__defendia_mutation_observer_added) {
        const observer = new MutationObserver((mutations) => {
            mutations.forEach((mutation) => {
                if (mutation.type === 'childList') {
                    mutation.addedNodes.forEach((node) => {
                        if (node.nodeType === Node.ELEMENT_NODE) {
                            const element = node;
                            if (element.tagName === 'FORM') {
                                element.addEventListener('submit', handleFormSubmission, true);
                            }
                            const forms = element.querySelectorAll('form');
                            forms.forEach(form => {
                                form.addEventListener('submit', handleFormSubmission, true);
                            });
                        }
                    });
                }
            });
        });
        observer.observe(document.body, {
            childList: true,
            subtree: true
        });
        window.__defendia_mutation_observer_added = true;
    }
    // Method 3: Button click detection for forms without submit events
    if (!window.__defendia_button_listener_added) {
        document.addEventListener('click', handleButtonClick, true);
        window.__defendia_button_listener_added = true;
    }
    // Method 3.5: Enhanced Google login detection
    if (!window.__defendia_google_detection_added) {
        // Monitor for Google-specific login patterns
        const googleLoginObserver = new MutationObserver((mutations) => {
            mutations.forEach((mutation) => {
                if (mutation.type === 'childList') {
                    mutation.addedNodes.forEach((node) => {
                        if (node.nodeType === Node.ELEMENT_NODE) {
                            const element = node;
                            // Check for Google login buttons or forms
                            const googleButtons = element.querySelectorAll('[data-provider="google"], [class*="google"], [id*="google"], button[aria-label*="Google"], button[aria-label*="google"]');
                            googleButtons.forEach(button => {
                                if (!button.__defendia_google_handled) {
                                    button.addEventListener('click', () => {
                                        console.log('Defendia: Google login button clicked');
                                        setTimeout(() => {
                                            // Check for form data after click
                                            const forms = document.querySelectorAll('form');
                                            forms.forEach(form => {
                                                const inputs = form.querySelectorAll('input');
                                                const hasEmail = Array.from(inputs).some(input => {
                                                    var _a, _b;
                                                    return input.type === 'email' ||
                                                        ((_a = input.name) === null || _a === void 0 ? void 0 : _a.toLowerCase().includes('email')) ||
                                                        ((_b = input.id) === null || _b === void 0 ? void 0 : _b.toLowerCase().includes('email'));
                                                });
                                                const hasPassword = Array.from(inputs).some(input => input.type === 'password');
                                                if (hasEmail && hasPassword) {
                                                    console.log('Defendia: Google form detected after button click');
                                                    handleFormSubmission({ target: form, preventDefault: () => { } });
                                                }
                                            });
                                        }, 500);
                                    });
                                    button.__defendia_google_handled = true;
                                }
                            });
                        }
                    });
                }
            });
        });
        googleLoginObserver.observe(document.body, {
            childList: true,
            subtree: true
        });
        window.__defendia_google_detection_added = true;
    }
    // Method 4: Input change detection for real-time form monitoring
    if (!window.__defendia_input_listener_added) {
        document.addEventListener('input', handleInputChange, true);
        window.__defendia_input_listener_added = true;
    }
    // Method 4.5: Aggressive Google form monitoring
    if (!window.__defendia_google_form_monitor_added) {
        const monitorGoogleForms = () => {
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                if (!form.__defendia_google_monitored) {
                    // Add multiple event listeners for Google forms
                    ['submit', 'click', 'change'].forEach(eventType => {
                        form.addEventListener(eventType, (e) => {
                            const inputs = form.querySelectorAll('input');
                            const hasEmail = Array.from(inputs).some(input => {
                                var _a, _b, _c;
                                return input.type === 'email' ||
                                    ((_a = input.name) === null || _a === void 0 ? void 0 : _a.toLowerCase().includes('email')) ||
                                    ((_b = input.id) === null || _b === void 0 ? void 0 : _b.toLowerCase().includes('email')) ||
                                    ((_c = input.placeholder) === null || _c === void 0 ? void 0 : _c.toLowerCase().includes('email'));
                            });
                            const hasPassword = Array.from(inputs).some(input => input.type === 'password');
                            if (hasEmail && hasPassword) {
                                console.log(`Defendia: Google form ${eventType} event detected`);
                                setTimeout(() => {
                                    handleFormSubmission({ target: form, preventDefault: () => { } });
                                }, 100);
                            }
                        }, true);
                    });
                    form.__defendia_google_monitored = true;
                }
            });
        };
        // Monitor immediately
        monitorGoogleForms();
        // Monitor periodically for dynamically added forms
        const interval = setInterval(monitorGoogleForms, 2000);
        // Clean up on page unload
        window.addEventListener('beforeunload', () => {
            clearInterval(interval);
        });
        window.__defendia_google_form_monitor_added = true;
    }
    // Method 5: Enhanced detection for React/Angular/Vue apps
    if (!window.__defendia_enhanced_detection_added) {
        let lastUrl = location.href;
        const urlObserver = new MutationObserver(() => {
            if (location.href !== lastUrl) {
                lastUrl = location.href;
                setTimeout(() => {
                    const forms = document.querySelectorAll('form');
                    forms.forEach(form => {
                        if (!form.__defendia_enhanced_handled) {
                            form.addEventListener('submit', handleFormSubmission, true);
                            form.__defendia_enhanced_handled = true;
                        }
                    });
                }, 500);
            }
        });
        urlObserver.observe(document.body, {
            childList: true,
            subtree: true
        });
        window.__defendia_enhanced_detection_added = true;
    }
    // Method 6: Enhanced iframe detection for modern websites
    if (!window.__defendia_iframe_detection_added) {
        const iframes = document.querySelectorAll('iframe');
        iframes.forEach(iframe => {
            try {
                if (iframe.contentDocument) {
                    const iframeForms = iframe.contentDocument.querySelectorAll('form');
                    iframeForms.forEach(form => {
                        form.addEventListener('submit', handleFormSubmission, true);
                    });
                }
            }
            catch (e) {
                console.log('Cross-origin iframe detected, using alternative detection methods');
            }
        });
        window.__defendia_iframe_detection_added = true;
    }
    // Method 7: Fallback detection for websites with strict CSP (reduced frequency)
    if (!window.__defendia_fallback_detection_added) {
        setInterval(() => {
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                if (!form.__defendia_fallback_handled) {
                    try {
                        form.addEventListener('submit', handleFormSubmission, true);
                        form.__defendia_fallback_handled = true;
                    }
                    catch (e) {
                        form.__defendia_fallback_handled = true;
                    }
                }
            });
        }, 5000); // Reduced from 2000ms to 5000ms
        window.__defendia_fallback_detection_added = true;
    }
    if (!window.__defendia_social_media_detection_added) {
        const socialMediaPatterns = [
            'facebook.com',
            'instagram.com',
            'twitter.com',
            'linkedin.com',
            'github.com',
            'google.com',
            'microsoft.com',
            'apple.com'
        ];
        const isSocialMediaSite = socialMediaPatterns.some(pattern => window.location.hostname.includes(pattern));
        if (isSocialMediaSite) {
            // console.log('Social media site detected, using enhanced detection methods');
            setInterval(() => {
                const inputContainers = document.querySelectorAll('[class*="input"], [class*="field"], [class*="form"]');
                inputContainers.forEach(container => {
                    if (!container.__defendia_social_media_handled) {
                        const inputs = container.querySelectorAll('input');
                        if (inputs.length >= 2) {
                            const virtualForm = {
                                querySelectorAll: (selector) => container.querySelectorAll(selector),
                                id: container.id || 'social-media-form',
                                submit: () => { }
                            };
                            container.__defendia_social_media_handled = true;
                        }
                    }
                });
            }, 10000); // Reduced from 1000ms to 10000ms
        }
        window.__defendia_social_media_detection_added = true;
    }
    if (!window.__defendia_popup_blocking_handled) {
        const problematicSites = [
            'facebook.com',
            'instagram.com',
            'twitter.com',
            'linkedin.com'
        ];
        const isProblematicSite = problematicSites.some(pattern => window.location.hostname.includes(pattern));
        if (isProblematicSite) {
            // console.log('Problematic site detected, using direct popup approach');
            window.__defendia_use_direct_popup = true;
        }
        window.__defendia_popup_blocking_handled = true;
    }
}
function handleButtonClick(event) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z;
    const target = event.target;
    if (!target)
        return;
    const isSubmitButton = target.tagName === 'BUTTON' &&
        (target.type === 'submit' ||
            ((_a = target.textContent) === null || _a === void 0 ? void 0 : _a.toLowerCase().includes('login')) ||
            ((_b = target.textContent) === null || _b === void 0 ? void 0 : _b.toLowerCase().includes('sign in')) ||
            ((_c = target.textContent) === null || _c === void 0 ? void 0 : _c.toLowerCase().includes('submit')) ||
            ((_d = target.textContent) === null || _d === void 0 ? void 0 : _d.toLowerCase().includes('continue')) ||
            ((_e = target.textContent) === null || _e === void 0 ? void 0 : _e.toLowerCase().includes('next')) ||
            ((_f = target.textContent) === null || _f === void 0 ? void 0 : _f.toLowerCase().includes('log in')) ||
            ((_g = target.textContent) === null || _g === void 0 ? void 0 : _g.toLowerCase().includes('signin')) ||
            ((_h = target.textContent) === null || _h === void 0 ? void 0 : _h.toLowerCase().includes('enter')) ||
            ((_j = target.textContent) === null || _j === void 0 ? void 0 : _j.toLowerCase().includes('proceed')) ||
            (
            // Google-specific patterns
            (_k = target.textContent) === null || _k === void 0 ? void 0 : _k.toLowerCase().includes('sign in with google')) ||
            ((_l = target.textContent) === null || _l === void 0 ? void 0 : _l.toLowerCase().includes('use google account')) ||
            ((_m = target.textContent) === null || _m === void 0 ? void 0 : _m.toLowerCase().includes('google')) ||
            (
            // Additional common patterns
            (_o = target.textContent) === null || _o === void 0 ? void 0 : _o.toLowerCase().includes('access')) ||
            ((_p = target.textContent) === null || _p === void 0 ? void 0 : _p.toLowerCase().includes('authenticate')) ||
            ((_q = target.textContent) === null || _q === void 0 ? void 0 : _q.toLowerCase().includes('verify')));
    const isSubmitInput = target.tagName === 'INPUT' &&
        (target.type === 'submit' ||
            target.type === 'button');
    const isButtonLike = (target.tagName === 'DIV' || target.tagName === 'SPAN') &&
        (((_r = target.textContent) === null || _r === void 0 ? void 0 : _r.toLowerCase().includes('login')) ||
            ((_s = target.textContent) === null || _s === void 0 ? void 0 : _s.toLowerCase().includes('sign in')) ||
            ((_t = target.textContent) === null || _t === void 0 ? void 0 : _t.toLowerCase().includes('submit')) ||
            ((_u = target.textContent) === null || _u === void 0 ? void 0 : _u.toLowerCase().includes('continue')) ||
            ((_v = target.textContent) === null || _v === void 0 ? void 0 : _v.toLowerCase().includes('next')) ||
            ((_w = target.textContent) === null || _w === void 0 ? void 0 : _w.toLowerCase().includes('log in')) ||
            ((_x = target.textContent) === null || _x === void 0 ? void 0 : _x.toLowerCase().includes('signin')) ||
            ((_y = target.textContent) === null || _y === void 0 ? void 0 : _y.toLowerCase().includes('enter')) ||
            ((_z = target.textContent) === null || _z === void 0 ? void 0 : _z.toLowerCase().includes('proceed')));
    if (isSubmitButton || isSubmitInput || isButtonLike) {
        console.log('Defendia: Submit button detected:', {
            tagName: target.tagName,
            textContent: target.textContent,
            type: target.type,
            isSubmitButton,
            isSubmitInput,
            isButtonLike
        });
        const form = target.closest('form') ||
            target.closest('[role="form"]') ||
            target.closest('[data-testid*="form"]') ||
            target.closest('[data-testid*="login"]') ||
            target.closest('[data-testid*="signin"]') ||
            target.closest('.login-form') ||
            target.closest('.signin-form') ||
            target.closest('[class*="login"]') ||
            target.closest('[class*="signin"]') ||
            // Google-specific selectors
            target.closest('[data-google-login]') ||
            target.closest('[class*="google"]') ||
            target.closest('[id*="google"]') ||
            target.closest('[data-testid*="google"]') ||
            // Additional common patterns
            target.closest('[class*="auth"]') ||
            target.closest('[class*="account"]') ||
            target.closest('[class*="sign"]') ||
            target.closest('[id*="auth"]') ||
            target.closest('[id*="account"]') ||
            target.closest('[id*="sign"]');
        if (form) {
            setTimeout(() => {
                handleFormSubmission({ target: form, preventDefault: () => { } });
            }, 100);
        }
        else {
            const formLikeContainer = target.closest('[class*="form"]') ||
                target.closest('[class*="login"]') ||
                target.closest('[class*="signin"]') ||
                target.closest('[class*="auth"]') ||
                // Google-specific containers
                target.closest('[class*="google"]') ||
                target.closest('[id*="google"]') ||
                target.closest('[data-testid*="google"]') ||
                target.closest('[data-google-login]') ||
                // Additional patterns
                target.closest('[class*="account"]') ||
                target.closest('[class*="sign"]') ||
                target.closest('[id*="auth"]') ||
                target.closest('[id*="account"]') ||
                target.closest('[id*="sign"]') ||
                // Generic containers that might contain login forms
                target.closest('[role="main"]') ||
                target.closest('[role="dialog"]') ||
                target.closest('.modal') ||
                target.closest('[class*="modal"]');
            if (formLikeContainer) {
                const inputs = formLikeContainer.querySelectorAll('input');
                if (inputs.length > 0) {
                    const virtualForm = {
                        querySelectorAll: (selector) => formLikeContainer.querySelectorAll(selector),
                        id: formLikeContainer.id || 'virtual-form',
                        submit: () => { }
                    };
                    setTimeout(() => {
                        handleFormSubmission({ target: virtualForm, preventDefault: () => { } });
                    }, 100);
                }
            }
        }
    }
}
function handleInputChange(event) {
    var _a, _b;
    const target = event.target;
    if (!target || target.type === 'submit' || target.type === 'button')
        return;
    if (!window.__defendia_form_data) {
        window.__defendia_form_data = new Map();
    }
    const formId = ((_a = target.form) === null || _a === void 0 ? void 0 : _a.id) || ((_b = target.closest('form')) === null || _b === void 0 ? void 0 : _b.id) || 'default';
    if (!window.__defendia_form_data.has(formId)) {
        window.__defendia_form_data.set(formId, {});
    }
    const formData = window.__defendia_form_data.get(formId);
    formData[target.name || target.id || target.placeholder] = target.value;
    // Check if this looks like a Google login form being filled
    if (window.location.hostname.includes('google.com')) {
        const form = target.form || target.closest('form');
        if (form) {
            const inputs = form.querySelectorAll('input');
            const hasEmail = Array.from(inputs).some(input => {
                var _a, _b, _c;
                return input.type === 'email' ||
                    ((_a = input.name) === null || _a === void 0 ? void 0 : _a.toLowerCase().includes('email')) ||
                    ((_b = input.id) === null || _b === void 0 ? void 0 : _b.toLowerCase().includes('email')) ||
                    ((_c = input.placeholder) === null || _c === void 0 ? void 0 : _c.toLowerCase().includes('email'));
            });
            const hasPassword = Array.from(inputs).some(input => input.type === 'password');
            if (hasEmail && hasPassword) {
                // Check if both email and password have values
                const emailInput = Array.from(inputs).find(input => {
                    var _a, _b, _c;
                    return input.type === 'email' ||
                        ((_a = input.name) === null || _a === void 0 ? void 0 : _a.toLowerCase().includes('email')) ||
                        ((_b = input.id) === null || _b === void 0 ? void 0 : _b.toLowerCase().includes('email')) ||
                        ((_c = input.placeholder) === null || _c === void 0 ? void 0 : _c.toLowerCase().includes('email'));
                });
                const passwordInput = Array.from(inputs).find(input => input.type === 'password');
                if ((emailInput === null || emailInput === void 0 ? void 0 : emailInput.value) && (passwordInput === null || passwordInput === void 0 ? void 0 : passwordInput.value) && passwordInput.value.length > 4) {
                    console.log('Defendia: Google login form appears to be filled, monitoring for submission');
                    // Add a one-time listener for any form submission attempt
                    if (!form.__defendia_google_submission_monitored) {
                        const checkSubmission = () => {
                            console.log('Defendia: Checking Google form submission');
                            setTimeout(() => {
                                handleFormSubmission({ target: form, preventDefault: () => { } });
                            }, 100);
                        };
                        // Listen for various submission events
                        ['submit', 'click'].forEach(eventType => {
                            form.addEventListener(eventType, checkSubmission, { once: true });
                        });
                        // Also listen for Enter key on password field
                        passwordInput.addEventListener('keydown', (e) => {
                            if (e.key === 'Enter') {
                                console.log('Defendia: Enter pressed on Google password field');
                                checkSubmission();
                            }
                        }, { once: true });
                        form.__defendia_google_submission_monitored = true;
                    }
                }
            }
        }
    }
}
function handleFormSubmission(event) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e, _f, _g;
        const form = event.target;
        if (!form || !form.querySelectorAll)
            return;
        // Check if the currently focused element is a password field in a signup form
        const activeElement = document.activeElement;
        if (activeElement && activeElement.type === 'password') {
            // Check if this is a signup form
            const formText = ((_a = form.textContent) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
            const isSignupForm = formText.includes('sign up') ||
                formText.includes('signup') ||
                formText.includes('register') ||
                formText.includes('create account') ||
                formText.includes('create your account') ||
                formText.includes('join') ||
                formText.includes('get started');
            if (isSignupForm) {
                // Don't trigger save popup if user is just focusing on password field in signup form
                // Only save when they actually submit (click submit button)
                if (event.type !== 'submit' || !event.isTrusted) {
                    return;
                }
            }
        }
        // Enhanced Google login detection
        const isGoogleLoginForm = () => {
            var _a;
            const isGoogleDomain = window.location.hostname.includes('google.com') ||
                window.location.hostname.includes('accounts.google.com') ||
                window.location.hostname.includes('myaccount.google.com');
            // Only check for Google-specific text if we're on a Google domain
            if (!isGoogleDomain) {
                return false;
            }
            const pageText = ((_a = document.body.textContent) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
            const hasGoogleText = pageText.includes('sign in with google') ||
                pageText.includes('use your google account') ||
                pageText.includes('google account') ||
                pageText.includes('sign in to google') ||
                pageText.includes('continue with google');
            const hasGoogleLogo = document.querySelector('[alt*="Google"], [src*="google"], [class*="google-logo"]') !== null;
            const hasGoogleButton = document.querySelector('[class*="google"], [id*="google"], [data-provider*="google"]') !== null;
            const result = isGoogleDomain && (hasGoogleText || hasGoogleLogo || hasGoogleButton);
            // Debug logging for Google detection
            if (isGoogleDomain) {
                console.log('Defendia: Google domain detected in form submission:', window.location.hostname);
            }
            return result;
        };
        const isGoogleLogin = isGoogleLoginForm();
        console.log('Defendia: Form submission detected:', {
            formId: form.id,
            formClass: form.className,
            formAction: form.action,
            inputsCount: form.querySelectorAll('input').length,
            hasPassword: form.querySelector('input[type="password"]') !== null,
            isGoogleLogin: isGoogleLogin,
            hostname: window.location.hostname,
            url: window.location.href
        });
        if (form.__defendia_handled)
            return;
        form.__defendia_handled = true;
        setTimeout(() => { delete form.__defendia_handled; }, 2000);
        const formData = new FormData(form);
        const values = {};
        const currentUrl = normalizeUrl(window.location.href);
        formData.forEach((value, key) => {
            values[key.toLowerCase()] = value.toString().trim();
        });
        const inputs = form.querySelectorAll('input');
        inputs.forEach(input => {
            const name = input.name.toLowerCase() || input.id.toLowerCase() || input.placeholder.toLowerCase();
            if (input.value && name) {
                values[name] = input.value.trim();
            }
        });
        const formId = form.id || 'default';
        if (window.__defendia_form_data && window.__defendia_form_data.has(formId)) {
            const storedData = window.__defendia_form_data.get(formId);
            Object.assign(values, storedData);
        }
        const enhancedValues = enhanceFieldDetection(values, inputs);
        let shouldPromptToSave = false;
        const typesToSave = [];
        // Enhanced password detection with Google-specific handling
        if (enhancedValues['password'] &&
            enhancedValues['password'].length > 4 &&
            (enhancedValues['username'] || enhancedValues['email'] || enhancedValues['login'])) {
            console.log('Defendia: Password form detected for saving:', {
                hasPassword: !!enhancedValues['password'],
                passwordLength: (_b = enhancedValues['password']) === null || _b === void 0 ? void 0 : _b.length,
                hasUsername: !!enhancedValues['username'],
                hasEmail: !!enhancedValues['email'],
                hasLogin: !!enhancedValues['login'],
                isGoogleLogin: isGoogleLogin,
                enhancedValues: Object.keys(enhancedValues),
                currentUrl: currentUrl,
                hostname: window.location.hostname
            });
            shouldPromptToSave = true;
            typesToSave.push('password');
        }
        else if (isGoogleLogin && enhancedValues['password'] && enhancedValues['password'].length > 4) {
            // Special handling for Google multi-step login - check if we have stored email from previous step
            console.log('Defendia: Google password step detected, checking for stored email');
            // Check if we have email stored from previous step
            const storedEmail = window.__defendia_google_email || '';
            if (storedEmail) {
                console.log('Defendia: Found stored Google email, proceeding with save:', storedEmail);
                enhancedValues['email'] = storedEmail;
                enhancedValues['username'] = storedEmail;
                shouldPromptToSave = true;
                typesToSave.push('password');
            }
            else {
                console.log('Defendia: No stored Google email found, storing current form data for next step');
                // Store current form data for potential use in next step
                window.__defendia_google_form_data = enhancedValues;
            }
        }
        else if (isGoogleLogin && (enhancedValues['username'] || enhancedValues['email']) && !enhancedValues['password']) {
            // This is the email step of Google login - store the email for password step
            const email = enhancedValues['username'] || enhancedValues['email'];
            console.log('Defendia: Google email step detected, storing email for password step:', email);
            window.__defendia_google_email = email;
        }
        else {
            console.log('Defendia: Password form NOT detected:', {
                hasPassword: !!enhancedValues['password'],
                passwordLength: (_c = enhancedValues['password']) === null || _c === void 0 ? void 0 : _c.length,
                hasUsername: !!enhancedValues['username'],
                hasEmail: !!enhancedValues['email'],
                hasLogin: !!enhancedValues['login'],
                isGoogleLogin: isGoogleLogin,
                enhancedValues: Object.keys(enhancedValues)
            });
        }
        if ((enhancedValues['cardnumber'] || enhancedValues['ccnumber'] || enhancedValues['number'] || enhancedValues['card']) &&
            (enhancedValues['expirationdate'] || enhancedValues['expdate'] || enhancedValues['exp'] || enhancedValues['expiry']) &&
            (enhancedValues['cvv'] || enhancedValues['cvc'] || enhancedValues['securitycode'])) {
            shouldPromptToSave = true;
            typesToSave.push('card');
        }
        if ((enhancedValues['firstname'] || enhancedValues['lastname'] || enhancedValues['fullname'] || enhancedValues['name'] || enhancedValues['cardholdername']) &&
            (enhancedValues['email'] || enhancedValues['phone'] || enhancedValues['address'] || enhancedValues['address1'])) {
            // Check if this is a signup form - if so, prioritize login over personal details
            const formText = ((_d = form.textContent) === null || _d === void 0 ? void 0 : _d.toLowerCase()) || '';
            const isSignupForm = formText.includes('sign up') ||
                formText.includes('signup') ||
                formText.includes('register') ||
                formText.includes('create account') ||
                formText.includes('create your account') ||
                formText.includes('join') ||
                formText.includes('get started');
            if (isSignupForm && typesToSave.includes('password')) {
                // For signup forms with both login and personal data, prioritize login
                // Don't add personal to typesToSave if we already have password
                console.log('Signup form detected: prioritizing login save over personal details save');
            }
            else {
                shouldPromptToSave = true;
                typesToSave.push('personal');
            }
        }
        // Additional check: if this is a signup form and we have both password and personal,
        // remove personal to prioritize login
        if (typesToSave.includes('password') && typesToSave.includes('personal')) {
            const formText = ((_e = form.textContent) === null || _e === void 0 ? void 0 : _e.toLowerCase()) || '';
            const isSignupForm = formText.includes('sign up') ||
                formText.includes('signup') ||
                formText.includes('register') ||
                formText.includes('create account') ||
                formText.includes('create your account') ||
                formText.includes('join') ||
                formText.includes('get started');
            if (isSignupForm) {
                // Remove personal from typesToSave to prioritize login
                const personalIndex = typesToSave.indexOf('personal');
                if (personalIndex !== -1) {
                    typesToSave.splice(personalIndex, 1);
                    console.log('Signup form: removed personal from save types, prioritizing login');
                }
            }
        }
        const urlHost = normalizeUrl(window.location.href);
        let stored = {};
        try {
            if (isExtensionContextValid()) {
                stored = yield chrome.storage.local.get(['neverAskSites', 'passwords', 'credentials', 'cards', 'personalInfo']);
            }
            else {
                stored = {};
            }
        }
        catch (_h) { }
        try {
            const neverAsk = stored.neverAskSites || [];
            if (neverAsk.some((host) => normalizeUrl(host) === urlHost)) {
                shouldPromptToSave = false;
                typesToSave.length = 0;
            }
        }
        catch (_j) { }
        try {
            const inputsInForm = Array.from(form.querySelectorAll('input'));
            const usernameField = inputsInForm.find((f) => {
                const t = f.type.toLowerCase();
                const n = (f.name || '').toLowerCase();
                const i = (f.id || '').toLowerCase();
                const p = (f.placeholder || '').toLowerCase();
                return (t === 'text' || t === 'email') && (n.includes('user') || n.includes('login') || n.includes('email') || i.includes('user') || i.includes('login') || i.includes('email') || p.includes('user') || p.includes('login') || p.includes('email'));
            });
            const passwordField = inputsInForm.find((f) => f.type.toLowerCase() === 'password');
            const autoFilledCreds = ((_f = usernameField === null || usernameField === void 0 ? void 0 : usernameField.dataset) === null || _f === void 0 ? void 0 : _f.defendiaFilled) === '1' && ((_g = passwordField === null || passwordField === void 0 ? void 0 : passwordField.dataset) === null || _g === void 0 ? void 0 : _g.defendiaFilled) === '1';
            if (autoFilledCreds) {
                const idx = typesToSave.indexOf('password');
                if (idx !== -1)
                    typesToSave.splice(idx, 1);
            }
        }
        catch (_k) { }
        try {
            if (typesToSave.includes('password')) {
                const storedPw = Array.isArray(stored.passwords) ? stored.passwords : [];
                const legacy = Array.isArray(stored.credentials) ? stored.credentials.map((c) => ({
                    title: c.title || c.url || 'Login',
                    login: c.username || c.login || c.email || '',
                    password: c.password || '',
                    websites: c.url ? [c.url] : []
                })) : [];
                const allPw = [...storedPw, ...legacy];
                const loginVal = (enhancedValues['username'] || enhancedValues['email'] || enhancedValues['login'] || '').trim();
                const passVal = (enhancedValues['password'] || '').trim();
                const exists = allPw.some((p) => {
                    const sameUser = (p.login || '').trim().toLowerCase() === loginVal.toLowerCase();
                    const samePass = (p.password || '').trim() === passVal;
                    if (!sameUser || !samePass)
                        return false;
                    if (!Array.isArray(p.websites) || p.websites.length === 0)
                        return true;
                    return p.websites.some((u) => domainsMatch(u, urlHost));
                });
                if (exists) {
                    const idx = typesToSave.indexOf('password');
                    if (idx !== -1)
                        typesToSave.splice(idx, 1);
                }
            }
            if (typesToSave.includes('card')) {
                const storedCards = Array.isArray(stored.cards) ? stored.cards : [];
                const normalizeCard = (num) => (num || '').replace(/\D+/g, '');
                const formCard = normalizeCard(enhancedValues['cardnumber'] || enhancedValues['ccnumber'] || enhancedValues['number'] || enhancedValues['card'] || '');
                const exists = storedCards.some((c) => normalizeCard(c.cardNumber || '') === formCard && formCard.length > 0);
                if (exists) {
                    const idx = typesToSave.indexOf('card');
                    if (idx !== -1)
                        typesToSave.splice(idx, 1);
                }
            }
            if (typesToSave.includes('personal')) {
                const storedPI = Array.isArray(stored.personalInfo) ? stored.personalInfo : [];
                const email = (enhancedValues['email'] || '').trim().toLowerCase();
                const full = (enhancedValues['fullname'] || enhancedValues['name'] || enhancedValues['cardholdername'] || '').trim();
                const [firstFromFull, ...restName] = full.split(/\s+/);
                const firstName = (enhancedValues['firstname'] || firstFromFull || '').trim().toLowerCase();
                const lastName = (enhancedValues['lastname'] || restName.join(' ') || '').trim().toLowerCase();
                const address = (enhancedValues['address'] || enhancedValues['address1'] || '').trim().toLowerCase();
                const exists = storedPI.some((p) => {
                    const pEmail = (p.email || '').trim().toLowerCase();
                    const pFirst = (p.firstName || '').trim().toLowerCase();
                    const pLast = (p.lastName || '').trim().toLowerCase();
                    const pAddress = (p.address || p.addressLine1 || '').trim().toLowerCase();
                    const nameMatch = email && pEmail === email && (!firstName || pFirst === firstName) && (!lastName || pLast === lastName);
                    const addrMatch = address && pAddress === address;
                    return nameMatch || addrMatch;
                });
                if (exists) {
                    const idx = typesToSave.indexOf('personal');
                    if (idx !== -1)
                        typesToSave.splice(idx, 1);
                }
            }
        }
        catch (_l) { }
        if (shouldPromptToSave && typesToSave.length) {
            console.log('Defendia: Prompting to save data:', {
                shouldPromptToSave,
                typesToSave,
                currentUrl,
                hostname: window.location.hostname,
                isGoogleLogin,
                enhancedValues: Object.keys(enhancedValues),
                neverAskSites: stored.neverAskSites || []
            });
            if (event.preventDefault) {
                event.preventDefault();
            }
            removeAutofillPopup();
            removePasswordGeneratorPopup();
            const payloads = typesToSave.map((t) => {
                var _a;
                if (t === 'password') {
                    // Generate title from domain only
                    const domainName = window.location.hostname.replace(/^www\./, '');
                    let title = '';
                    if (isGoogleLogin) {
                        // For Google logins, use a clean format
                        if (domainName.includes('accounts.google.com')) {
                            title = 'Google Account';
                        }
                        else if (domainName.includes('google.com')) {
                            title = 'Google Account';
                        }
                        else {
                            title = `Google Account (${domainName})`;
                        }
                    }
                    else {
                        title = domainName;
                    }
                    // For Google multi-step login, ensure we have both email and password
                    let username = enhancedValues['username'] || enhancedValues['email'] || enhancedValues['login'] || '';
                    let password = enhancedValues['password'] || '';
                    // If we're missing username but have stored Google email, use it
                    if (!username && isGoogleLogin && window.__defendia_google_email) {
                        username = window.__defendia_google_email;
                    }
                    // If we're missing password but have stored Google form data, use it
                    if (!password && isGoogleLogin && ((_a = window.__defendia_google_form_data) === null || _a === void 0 ? void 0 : _a.password)) {
                        password = window.__defendia_google_form_data.password;
                    }
                    return {
                        type: t,
                        formData: {
                            username: username,
                            password: password,
                            email: username, // Use username as email for Google accounts
                            title: title,
                            isGoogleLogin: isGoogleLogin
                        },
                        domain: currentUrl,
                        isGoogleLogin: isGoogleLogin
                    };
                }
                if (t === 'card') {
                    // Generate title from domain only
                    const domainName = window.location.hostname.replace(/^www\./, '');
                    const title = domainName;
                    return {
                        type: t,
                        formData: {
                            cardNumber: enhancedValues['cardnumber'] || enhancedValues['ccnumber'] || enhancedValues['number'] || enhancedValues['card'] || '',
                            cardholderName: enhancedValues['cardholdername'] || enhancedValues['name'] || '',
                            expirationDate: enhancedValues['expirationdate'] || enhancedValues['expdate'] || enhancedValues['exp'] || enhancedValues['expiry'] || '',
                            cvv: enhancedValues['cvv'] || enhancedValues['cvc'] || enhancedValues['securitycode'] || '',
                            title: title
                        },
                        domain: currentUrl
                    };
                }
                // personal
                // Generate title from domain only
                const domainName = window.location.hostname.replace(/^www\./, '');
                const title = domainName;
                const full = enhancedValues['fullname'] || enhancedValues['name'] || enhancedValues['cardholdername'] || '';
                const [firstFromFull, ...restName] = full.split(/\s+/);
                return {
                    type: t,
                    formData: {
                        firstName: enhancedValues['firstname'] || firstFromFull || '',
                        lastName: enhancedValues['lastname'] || restName.join(' ') || '',
                        email: enhancedValues['email'] || '',
                        phone: enhancedValues['phone'] || '',
                        address: enhancedValues['address'] || enhancedValues['address1'] || '',
                        city: enhancedValues['city'] || '',
                        state: enhancedValues['state'] || '',
                        zipCode: enhancedValues['zipcode'] || enhancedValues['zip'] || '',
                        country: enhancedValues['country'] || '',
                        title: title
                    },
                    domain: currentUrl
                };
            });
            const safeSendMessage = (msg, cb) => {
                var _a, _b;
                try {
                    console.log('Content: Attempting to send message:', msg.type, 'isExtensionContextValid:', isExtensionContextValid(), 'hasChromeRuntime:', !!((_a = chrome.runtime) === null || _a === void 0 ? void 0 : _a.sendMessage));
                    if (!isExtensionContextValid() || !((_b = chrome.runtime) === null || _b === void 0 ? void 0 : _b.sendMessage)) {
                        console.log('Content: Extension context invalid or no chrome.runtime, skipping message');
                        cb();
                        return;
                    }
                    chrome.runtime.sendMessage(msg, () => {
                        if (chrome.runtime.lastError) {
                            const m = chrome.runtime.lastError.message || '';
                            console.error('Content: Error sending message:', chrome.runtime.lastError);
                            if (!m.includes('Extension context invalidated')) {
                                console.error('Content: Non-context error:', chrome.runtime.lastError);
                            }
                        }
                        else {
                            console.log('Content: Message sent successfully:', msg.type);
                        }
                        cb();
                    });
                }
                catch (e) {
                    const m = (e === null || e === void 0 ? void 0 : e.message) || '';
                    console.error('Content: Exception sending message:', e);
                    if (!m.includes('Extension context invalidated')) {
                        console.error('Content: Non-context exception:', e);
                    }
                    cb();
                }
            };
            let completed = 0;
            payloads.forEach((payload) => {
                console.log('Content: Sending PROMPT_SAVE_DATA message:', payload);
                safeSendMessage({ type: 'PROMPT_SAVE_DATA', payload }, () => {
                    console.log('Content: PROMPT_SAVE_DATA message sent, completed:', completed + 1, 'of', payloads.length);
                    completed += 1;
                    if (completed === payloads.length) {
                        setTimeout(() => {
                            try {
                                if (typeof form.requestSubmit === 'function') {
                                    form.requestSubmit();
                                }
                                else {
                                    const submitter = form.querySelector('[type="submit"], button:not([type]), input[type="submit"]');
                                    if (submitter && typeof submitter.click === 'function') {
                                        submitter.click();
                                    }
                                    else if (typeof form.submit === 'function') {
                                        form.submit();
                                    }
                                }
                            }
                            catch (e) {
                                console.log('Form submission handled by website (SPA)');
                            }
                        }, 100);
                    }
                });
            });
        }
        else {
            try {
                if (typeof form.requestSubmit === 'function') {
                    form.requestSubmit();
                }
                else {
                    const submitter = form.querySelector('[type="submit"], button:not([type]), input[type="submit"]');
                    if (submitter && typeof submitter.click === 'function') {
                        submitter.click();
                    }
                    else if (typeof form.submit === 'function') {
                        form.submit();
                    }
                }
            }
            catch (e) {
                console.log('Form submission handled by website (SPA)');
            }
        }
    });
}
function enhanceFieldDetection(values, inputs) {
    const enhanced = Object.assign({}, values);
    const fieldMappings = {
        // Username/Login fields
        'user': ['username', 'login', 'userid', 'user_id', 'user-id'],
        'login': ['username', 'userid', 'user_id', 'user-id'],
        'email': ['email', 'e-mail', 'mail', 'emailaddress', 'email_address'],
        // Password fields
        'password': ['password', 'pass', 'pwd', 'passwd', 'userpassword', 'user_password'],
        // Card fields
        'card': ['cardnumber', 'ccnumber', 'number', 'card_number', 'card-number', 'cc_number', 'cc-number'],
        'expiry': ['expirationdate', 'expdate', 'exp', 'expiry', 'expiration_date', 'expiration-date'],
        'cvv': ['cvv', 'cvc', 'securitycode', 'security_code', 'security-code', 'cardcvv', 'card_cvv'],
        // Personal fields
        'firstname': ['firstname', 'first_name', 'first-name', 'fname', 'givenname', 'given_name'],
        'lastname': ['lastname', 'last_name', 'last-name', 'lname', 'surname', 'familyname', 'family_name'],
        'fullname': ['fullname', 'full_name', 'full-name', 'name', 'displayname', 'display_name'],
        'phone': ['phone', 'telephone', 'tel', 'mobile', 'cell', 'cellphone', 'cell_phone'],
        'address': ['address', 'street', 'addr', 'streetaddress', 'street_address', 'address1', 'address_1'],
        'city': ['city', 'town', 'locality'],
        'state': ['state', 'province', 'region', 'stateorregion', 'state_or_region'],
        'zip': ['zip', 'zipcode', 'zip_code', 'postal', 'postalcode', 'postal_code', 'pincode', 'pin_code']
    };
    Object.entries(fieldMappings).forEach(([key, aliases]) => {
        if (enhanced[key])
            return;
        for (const alias of aliases) {
            if (enhanced[alias]) {
                enhanced[key] = enhanced[alias];
                break;
            }
        }
    });
    inputs.forEach(input => {
        var _a, _b, _c, _d, _e;
        const name = ((_a = input.name) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
        const id = ((_b = input.id) === null || _b === void 0 ? void 0 : _b.toLowerCase()) || '';
        const placeholder = ((_c = input.placeholder) === null || _c === void 0 ? void 0 : _c.toLowerCase()) || '';
        const autocomplete = ((_d = input.autocomplete) === null || _d === void 0 ? void 0 : _d.toLowerCase()) || '';
        const value = ((_e = input.value) === null || _e === void 0 ? void 0 : _e.trim()) || '';
        if (!value)
            return;
        if (autocomplete.includes('username') || autocomplete.includes('email')) {
            enhanced['username'] = enhanced['username'] || value;
            enhanced['email'] = enhanced['email'] || value;
        }
        if (autocomplete.includes('current-password') || autocomplete.includes('new-password')) {
            enhanced['password'] = enhanced['password'] || value;
        }
        if (autocomplete.startsWith('cc-')) {
            enhanced['card'] = enhanced['card'] || value;
        }
        if (autocomplete.includes('given-name')) {
            enhanced['firstname'] = enhanced['firstname'] || value;
        }
        if (autocomplete.includes('family-name')) {
            enhanced['lastname'] = enhanced['lastname'] || value;
        }
        if (autocomplete.includes('tel')) {
            enhanced['phone'] = enhanced['phone'] || value;
        }
        if (autocomplete.includes('street-address')) {
            enhanced['address'] = enhanced['address'] || value;
        }
    });
    return enhanced;
}
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    if (message.type === 'SHOW_SAVE_LOGIN_POPUP') {
        try {
            showSaveLoginPopup(message.data);
        }
        catch (error) {
            console.error('Failed to show save login popup:', error);
            try {
                chrome.runtime.sendMessage({ type: 'OPEN_SAVE_LOGIN_POPUP', data: message.data });
            }
            catch (fallbackError) {
                console.error('Fallback popup opening also failed:', fallbackError);
            }
        }
    }
    if (message.type === 'SHOW_SAVE_PERSONAL_DETAILS_POPUP') {
        try {
            showSavePersonalDetailsPopup(message.data);
        }
        catch (error) {
            console.error('Failed to show save personal details popup:', error);
            try {
                chrome.runtime.sendMessage({ type: 'OPEN_SAVE_PERSONAL_POPUP', data: message.data });
            }
            catch (fallbackError) {
                console.error('Fallback popup opening also failed:', fallbackError);
            }
        }
    }
    if (message.type === 'SHOW_SAVE_CARD_DETAILS_POPUP') {
        try {
            showSaveCardDetailsPopup(message.data);
        }
        catch (error) {
            console.error('Failed to show save card details popup:', error);
            try {
                chrome.runtime.sendMessage({ type: 'OPEN_SAVE_CARD_POPUP', data: message.data });
            }
            catch (fallbackError) {
                console.error('Fallback popup opening also failed:', fallbackError);
            }
        }
    }
    if (message.type === 'REFRESH_AUTOFILL_DATA') {
        // console.log('Received autofill refresh request:', message.action);
        if (message.action === 'item_saved') {
            refreshAutofillDataCache();
            setTimeout(() => {
                syncAutofillDataWithStorage();
            }, 200);
            setTimeout(() => {
                refreshActiveInputsAutofill();
            }, 300);
        }
        if (message.action === 'item_deleted') {
            // console.log('Item deleted, refreshing autofill data:', message.itemType, message.itemId);
            refreshAutofillDataCache();
            setTimeout(() => {
                syncAutofillDataWithStorage();
            }, 200);
            setTimeout(() => {
                refreshActiveInputsAutofill();
            }, 300);
        }
        if (message.action === 'popup_closed') {
            // console.log('Popup closed, refreshing autofill data');
            refreshAutofillDataCache();
            setTimeout(() => {
                syncAutofillDataWithStorage();
            }, 200);
            setTimeout(() => {
                refreshActiveInputsAutofill();
            }, 300);
        }
    }
});
function showSaveLoginPopup(data) {
    const existing = document.getElementById('defendia-save-login-popup');
    if (existing)
        existing.remove();
    const useDirectPopup = window.__defendia_use_direct_popup;
    if (useDirectPopup) {
        try {
            chrome.runtime.sendMessage({ type: 'OPEN_SAVE_LOGIN_POPUP', data });
            return;
        }
        catch (error) {
            console.log('Direct popup failed, falling back to inline popup');
        }
    }
    const popupContainer = document.createElement('div');
    popupContainer.id = 'defendia-save-login-popup';
    popupContainer.style.cssText = `
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 999999;
  `;
    const popupContent = document.createElement('div');
    popupContent.style.cssText = `
    background: white;
    padding: 20px;
    border-radius: 8px;
    width: 400px;
    max-width: 90%;
    max-height: 90vh;
    overflow-y: auto;
    position: relative;
  `;
    const closeButton = document.createElement('button');
    closeButton.textContent = '×';
    closeButton.style.cssText = `
    position: absolute;
    top: 10px;
    right: 10px;
    background: none;
    border: none;
    font-size: 24px;
    cursor: pointer;
    padding: 0;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
  `;
    closeButton.onclick = () => {
        document.body.removeChild(popupContainer);
    };
    const iframe = document.createElement('iframe');
    iframe.src = safeGetURL('popup.html?view=saveLoginDetails');
    iframe.style.cssText = `
    width: 100%;
    height: 600px;
    border: none;
  `;
    popupContent.appendChild(closeButton);
    popupContent.appendChild(iframe);
    popupContainer.appendChild(popupContent);
    document.body.appendChild(popupContainer);
    popupContainer.addEventListener('click', (e) => {
        if (e.target === popupContainer) {
            document.body.removeChild(popupContainer);
        }
    });
}
function showSavePersonalDetailsPopup(data) {
    const existing = document.getElementById('defendia-save-personal-details-popup');
    if (existing)
        existing.remove();
    const useDirectPopup = window.__defendia_use_direct_popup;
    if (useDirectPopup) {
        try {
            chrome.runtime.sendMessage({ type: 'OPEN_SAVE_PERSONAL_POPUP', data });
            return;
        }
        catch (error) {
            console.log('Direct popup failed, falling back to inline popup');
        }
    }
    const popupContainer = document.createElement('div');
    popupContainer.id = 'defendia-save-personal-details-popup';
    popupContainer.style.cssText = `
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 999999;
  `;
    const popupContent = document.createElement('div');
    popupContent.style.cssText = `
    background: white;
    padding: 20px;
    border-radius: 8px;
    width: 400px;
    max-width: 90%;
    max-height: 90vh;
    overflow-y: auto;
    position: relative;
  `;
    const closeButton = document.createElement('button');
    closeButton.textContent = '×';
    closeButton.style.cssText = `
    position: absolute;
    top: 10px;
    right: 10px;
    background: none;
    border: none;
    font-size: 24px;
    cursor: pointer;
    padding: 0;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
  `;
    closeButton.onclick = () => {
        document.body.removeChild(popupContainer);
    };
    const iframe = document.createElement('iframe');
    iframe.src = safeGetURL('popup.html?view=savePersonalDetails');
    iframe.style.cssText = `
    width: 100%;
    height: 600px;
    border: none;
  `;
    popupContent.appendChild(closeButton);
    popupContent.appendChild(iframe);
    popupContainer.appendChild(popupContent);
    document.body.appendChild(popupContainer);
    popupContainer.addEventListener('click', (e) => {
        if (e.target === popupContainer) {
            document.body.removeChild(popupContainer);
        }
    });
}
function showSaveCardDetailsPopup(data) {
    const existing = document.getElementById('defendia-save-card-details-popup');
    if (existing)
        existing.remove();
    const useDirectPopup = window.__defendia_use_direct_popup;
    if (useDirectPopup) {
        try {
            chrome.runtime.sendMessage({ type: 'OPEN_SAVE_CARD_POPUP', data });
            return;
        }
        catch (error) {
            console.log('Direct popup failed, falling back to inline popup');
        }
    }
    const popupContainer = document.createElement('div');
    popupContainer.id = 'defendia-save-card-details-popup';
    popupContainer.style.cssText = `
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 999999;
  `;
    const popupContent = document.createElement('div');
    popupContent.style.cssText = `
    background: white;
    padding: 20px;
    border-radius: 8px;
    width: 400px;
    max-width: 90%;
    max-height: 90vh;
    overflow-y: auto;
    position: relative;
  `;
    const closeButton = document.createElement('button');
    closeButton.textContent = '×';
    closeButton.style.cssText = `
    position: absolute;
    top: 10px;
    right: 10px;
    background: none;
    border: none;
    font-size: 24px;
    cursor: pointer;
    padding: 0;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
  `;
    closeButton.onclick = () => {
        document.body.removeChild(popupContainer);
    };
    const iframe = document.createElement('iframe');
    iframe.src = safeGetURL('popup.html?view=saveCardDetails');
    iframe.style.cssText = `
    width: 100%;
    height: 600px;
    border: none;
  `;
    popupContent.appendChild(closeButton);
    popupContent.appendChild(iframe);
    popupContainer.appendChild(popupContent);
    document.body.appendChild(popupContainer);
    popupContainer.addEventListener('click', (e) => {
        if (e.target === popupContainer) {
            document.body.removeChild(popupContainer);
        }
    });
}
function getPopupTitleForFieldType(isCardField, isPersonalField, isUsernameField, isPasswordField) {
    if (isCardField) {
        return 'Autofill Credit Card';
    }
    else if (isPersonalField) {
        return 'Autofill Personal Info';
    }
    else if (isPasswordField) {
        return 'Autofill Password';
    }
    else if (isUsernameField) {
        return 'Autofill Email';
    }
    else {
        return 'Autofill';
    }
}
function getDomainIconForSuggestion(suggestion) {
    var _a;
    let domain = '';
    // console.log('getDomainIconForSuggestion input:', {
    //   suggestion,
    //   type: suggestion.type,
    //   websites: suggestion.websites,
    //   email: suggestion.email
    // });
    if (suggestion.type === 'password' && suggestion.websites && suggestion.websites.length > 0) {
        try {
            const url = new URL(suggestion.websites[0]);
            domain = url.hostname.toLowerCase();
            // console.log('Extracted domain from URL:', domain);
        }
        catch (_b) {
            const urlStr = suggestion.websites[0];
            if (urlStr && typeof urlStr === 'string') {
                domain = urlStr.replace(/^https?:\/\//, '').replace(/\/.*$/, '').replace(/^www\./, '').toLowerCase();
                // console.log('Extracted domain from string:', domain);
            }
        }
    }
    else if (suggestion.type === 'personal' && suggestion.email) {
        domain = ((_a = suggestion.email.split('@')[1]) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
        // console.log('Extracted domain from email:', domain);
    }
    if (!domain) {
        domain = window.location.hostname.toLowerCase();
        // console.log('Using current domain as fallback:', domain);
    }
    if (suggestion.type === 'password' && domain) {
        return {
            background: '#F0F0F0',
            svg: '<div class="favicon-placeholder" style="width: 20px; height: 20px; background: #F0F0F0; border-radius: 4px; display: flex; align-items: center; justify-content: center; font-size: 12px; color: #666;">...</div>',
            faviconUrl: domain
        };
    }
    if (domain.includes('netflix')) {
        return {
            background: '#E50914',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#E50914"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">N</text></svg>'
        };
    }
    else if (domain.includes('gmail') || domain.includes('google')) {
        // Enhanced Google icon for Google login suggestions
        if (suggestion.isGoogleLogin) {
            return {
                background: '#4285F4',
                svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z" fill="#4285F4"/><path d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z" fill="#34A853"/><path d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z" fill="#FBBC05"/><path d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z" fill="#EA4335"/></svg>'
            };
        }
        return {
            background: '#4285F4',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#4285F4"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">G</text></svg>'
        };
    }
    else if (domain.includes('facebook')) {
        return {
            background: '#1877F2',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#1877F2"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">f</text></svg>'
        };
    }
    else if (domain.includes('amazon')) {
        return {
            background: '#FF9900',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#FF9900"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">A</text></svg>'
        };
    }
    else if (domain.includes('apple')) {
        return {
            background: '#000000',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#000000"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">🍎</text></svg>'
        };
    }
    else if (domain.includes('microsoft') || domain.includes('outlook') || domain.includes('hotmail')) {
        return {
            background: '#0078D4',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#0078D4"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">M</text></svg>'
        };
    }
    else if (domain.includes('twitter') || domain.includes('x.com')) {
        return {
            background: '#1DA1F2',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#1DA1F2"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">𝕏</text></svg>'
        };
    }
    else if (domain.includes('linkedin')) {
        return {
            background: '#0077B5',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#0077B5"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">in</text></svg>'
        };
    }
    else if (domain.includes('github')) {
        return {
            background: '#333333',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#333333"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">G</text></svg>'
        };
    }
    else if (domain.includes('youtube')) {
        return {
            background: '#FF0000',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#FF0000"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">▶</text></svg>'
        };
    }
    else if (domain.includes('instagram')) {
        return {
            background: '#E4405F',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#E4405F"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">📷</text></svg>'
        };
    }
    else if (domain.includes('discord')) {
        return {
            background: '#5865F2',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#5865F2"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">D</text></svg>'
        };
    }
    else if (domain.includes('slack')) {
        return {
            background: '#4A154B',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#4A154B"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">S</text></svg>'
        };
    }
    else if (domain.includes('dropbox')) {
        return {
            background: '#0061FF',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#0061FF"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">D</text></svg>'
        };
    }
    else if (domain.includes('spotify')) {
        return {
            background: '#1DB954',
            svg: '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="24" height="24" rx="4" fill="#1DB954"/><text x="12" y="16" text-anchor="middle" fill="white" font-family="Arial, sans-serif" font-size="14" font-weight="bold">♪</text></svg>'
        };
    }
    return null;
}
function detectPasswordFields() {
    const passwordInputs = document.querySelectorAll('input[type="password"]');
    passwordInputs.forEach((input) => {
        if (input instanceof HTMLInputElement) {
            if (input.value && input.value.trim().length > 0) {
                return;
            }
            if (input.autocomplete === 'current-password') {
                return;
            }
            const isSignUpForm = () => {
                var _a, _b, _c, _d;
                const form = input.closest('form');
                if (!form)
                    return false;
                const formText = ((_a = form.textContent) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
                const formAction = (form.action || '').toLowerCase();
                const formId = (form.id || '').toLowerCase();
                const formClass = (form.className || '').toLowerCase();
                const formMethod = (form.method || '').toLowerCase();
                // STRICT LOGIN DETECTION - Check for ANY login indicators first
                const hasLoginText = formText.includes('sign in') ||
                    formText.includes('signin') ||
                    formText.includes('login') ||
                    formText.includes('log in') ||
                    formText.includes('sign in to') ||
                    formText.includes('login to') ||
                    formText.includes('access your account') ||
                    formText.includes('welcome back') ||
                    formText.includes('enter your password') ||
                    formText.includes('forgot password') ||
                    formText.includes('reset password') ||
                    formText.includes('remember me') ||
                    formText.includes('sign in with') ||
                    formText.includes('continue with') ||
                    formAction.includes('login') ||
                    formAction.includes('signin') ||
                    formAction.includes('authenticate') ||
                    formAction.includes('auth') ||
                    formId.includes('login') ||
                    formId.includes('signin') ||
                    formId.includes('sign-in') ||
                    formId.includes('auth') ||
                    formClass.includes('login') ||
                    formClass.includes('signin') ||
                    formClass.includes('sign-in') ||
                    formClass.includes('auth');
                // Check for current password autocomplete
                const isCurrentPassword = input.autocomplete === 'current-password';
                // Check for common login page patterns
                const hasLoginPagePatterns = formText.includes('new to') ||
                    formText.includes('don\'t have an account') ||
                    formText.includes('already have an account') ||
                    formText.includes('existing user') ||
                    formText.includes('returning user');
                // If it's clearly a login form, return false (don't show password generator)
                if (hasLoginText || isCurrentPassword || hasLoginPagePatterns) {
                    return false;
                }
                // Check for additional login indicators in the page context
                const pageText = ((_b = document.body.textContent) === null || _b === void 0 ? void 0 : _b.toLowerCase()) || '';
                const pageTitle = ((_c = document.title) === null || _c === void 0 ? void 0 : _c.toLowerCase()) || '';
                const pageUrl = ((_d = window.location.href) === null || _d === void 0 ? void 0 : _d.toLowerCase()) || '';
                const hasPageLoginText = pageTitle.includes('login') ||
                    pageTitle.includes('sign in') ||
                    pageTitle.includes('signin') ||
                    pageTitle.includes('authenticate') ||
                    pageText.includes('welcome back') ||
                    pageText.includes('access your account') ||
                    pageText.includes('enter your credentials') ||
                    pageText.includes('forgot your password') ||
                    pageText.includes('remember me') ||
                    pageText.includes('new to') ||
                    pageText.includes('don\'t have an account') ||
                    pageText.includes('already have an account') ||
                    pageUrl.includes('/login') ||
                    pageUrl.includes('/signin') ||
                    pageUrl.includes('/sign-in') ||
                    pageUrl.includes('/auth');
                // If the page context suggests login, be more conservative
                if (hasPageLoginText) {
                    return false;
                }
                // Check for specific site patterns that are commonly login pages
                const domain = window.location.hostname.toLowerCase();
                const isCommonLoginSite = domain.includes('netflix') ||
                    domain.includes('amazon') ||
                    domain.includes('google') ||
                    domain.includes('facebook') ||
                    domain.includes('twitter') ||
                    domain.includes('instagram') ||
                    domain.includes('linkedin') ||
                    domain.includes('github') ||
                    domain.includes('microsoft') ||
                    domain.includes('apple') ||
                    domain.includes('spotify') ||
                    domain.includes('youtube');
                // For common sites, be extra strict - only show if we have very clear signup indicators
                if (isCommonLoginSite) {
                    // Only show password generator if we have VERY clear signup indicators
                    const hasVeryClearSignUpText = formText.includes('sign up') ||
                        formText.includes('signup') ||
                        formText.includes('register') ||
                        formText.includes('create account') ||
                        formText.includes('new account') ||
                        formText.includes('join') ||
                        formText.includes('registration') ||
                        formText.includes('create') ||
                        formText.includes('sign up for') ||
                        formText.includes('get started') ||
                        formText.includes('become a member');
                    const hasPasswordConfirm = form.querySelector('input[type="password"][name*="confirm"], input[type="password"][name*="reenter"], input[type="password"][name*="re-enter"], input[type="password"][id*="confirm"], input[type="password"][id*="reenter"], input[type="password"][id*="re-enter"]');
                    const isNewPassword = input.autocomplete === 'new-password';
                    // For common sites, only show if we have VERY clear signup indicators
                    if (hasVeryClearSignUpText || hasPasswordConfirm || isNewPassword) {
                        return true;
                    }
                    // For common sites, default to false (don't show password generator)
                    return false;
                }
                // For other sites, check for explicit signup indicators
                const hasSignUpText = formText.includes('sign up') ||
                    formText.includes('signup') ||
                    formText.includes('register') ||
                    formText.includes('create account') ||
                    formText.includes('new account') ||
                    formText.includes('join') ||
                    formText.includes('registration') ||
                    formText.includes('create') ||
                    formText.includes('sign up for') ||
                    formText.includes('get started') ||
                    formText.includes('become a member') ||
                    formText.includes('sign up with') ||
                    formText.includes('create your account') ||
                    formText.includes('new user') ||
                    formText.includes('register now') ||
                    formText.includes('join now');
                const hasPasswordConfirm = form.querySelector('input[type="password"][name*="confirm"], input[type="password"][name*="reenter"], input[type="password"][name*="re-enter"], input[type="password"][id*="confirm"], input[type="password"][id*="reenter"], input[type="password"][id*="re-enter"]');
                const isNewPassword = input.autocomplete === 'new-password';
                const hasMultiplePasswordFields = form.querySelectorAll('input[type="password"]').length > 1;
                const hasEmailField = form.querySelector('input[type="email"], input[name*="email"], input[id*="email"]');
                const hasUsernameField = form.querySelector('input[name*="username"], input[name*="user"], input[id*="username"], input[id*="user"]');
                const hasNameField = form.querySelector('input[name*="name"], input[id*="name"], input[placeholder*="name"]');
                const hasPhoneField = form.querySelector('input[type="tel"], input[name*="phone"], input[id*="phone"]');
                // If we have clear signup indicators, it's definitely a signup form
                if (hasSignUpText || hasPasswordConfirm || isNewPassword) {
                    return true;
                }
                // Check for multiple password fields with email/username (common signup pattern)
                if (hasMultiplePasswordFields && (hasEmailField || hasUsernameField)) {
                    return true;
                }
                // Check for signup form patterns: password field + email + name/phone
                if (hasEmailField && (hasNameField || hasPhoneField) && !hasLoginText) {
                    return true;
                }
                // Check for new password autocomplete
                if (isNewPassword) {
                    return true;
                }
                // Default to true for password fields (be more permissive for signup)
                return true;
            };
            if (!isSignUpForm()) {
                return;
            }
            // ULTRA-STRICT safety check: look for ANY login page indicators
            const isLikelyLoginPage = () => {
                var _a, _b, _c;
                const pageTitle = ((_a = document.title) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
                const pageUrl = ((_b = window.location.href) === null || _b === void 0 ? void 0 : _b.toLowerCase()) || '';
                const pageText = ((_c = document.body.textContent) === null || _c === void 0 ? void 0 : _c.toLowerCase()) || '';
                const domain = window.location.hostname.toLowerCase();
                // Check for login-related page titles and URLs
                const hasLoginPageTitle = pageTitle.includes('login') ||
                    pageTitle.includes('sign in') ||
                    pageTitle.includes('signin') ||
                    pageTitle.includes('authenticate') ||
                    pageTitle.includes('sign in to') ||
                    pageTitle.includes('welcome back');
                const hasLoginPageUrl = pageUrl.includes('/login') ||
                    pageUrl.includes('/signin') ||
                    pageUrl.includes('/sign-in') ||
                    pageUrl.includes('/auth') ||
                    pageUrl.includes('/signin/') ||
                    pageUrl.includes('/login/');
                // Check for common login page text patterns
                const hasLoginPageText = pageText.includes('welcome back') ||
                    pageText.includes('access your account') ||
                    pageText.includes('enter your credentials') ||
                    pageText.includes('forgot your password') ||
                    pageText.includes('remember me') ||
                    pageText.includes('new to') ||
                    pageText.includes('don\'t have an account') ||
                    pageText.includes('already have an account') ||
                    pageText.includes('existing user') ||
                    pageText.includes('returning user') ||
                    pageText.includes('sign in with') ||
                    pageText.includes('continue with');
                // Check for specific domains that are commonly login pages
                const isCommonLoginDomain = domain.includes('netflix') ||
                    domain.includes('amazon') ||
                    domain.includes('google') ||
                    domain.includes('facebook') ||
                    domain.includes('twitter') ||
                    domain.includes('instagram') ||
                    domain.includes('linkedin') ||
                    domain.includes('github') ||
                    domain.includes('microsoft') ||
                    domain.includes('apple') ||
                    domain.includes('spotify') ||
                    domain.includes('youtube');
                // For common login domains, be extra strict
                if (isCommonLoginDomain) {
                    // Only allow if we have VERY clear signup indicators on the page
                    const hasVeryClearSignUpPageText = pageText.includes('sign up') ||
                        pageText.includes('signup') ||
                        pageText.includes('register') ||
                        pageText.includes('create account') ||
                        pageText.includes('new account') ||
                        pageText.includes('join') ||
                        pageText.includes('registration') ||
                        pageText.includes('get started');
                    if (!hasVeryClearSignUpPageText) {
                        return true; // Block password generator on common login domains
                    }
                }
                return hasLoginPageTitle || hasLoginPageUrl || hasLoginPageText;
            };
            // If the page context suggests it's a login page, don't show password generator
            if (isLikelyLoginPage()) {
                return;
            }
            input.addEventListener('click', (e) => {
                if (e.target === input) {
                    debouncedShowPasswordGeneratorPopup(input);
                }
            });
            input.addEventListener('focus', () => {
                debouncedShowPasswordGeneratorPopup(input);
            });
        }
    });
}
// Track which input currently has the password generator popup
let currentPasswordGeneratorInput = null;
// Debounce mechanism for password generator popup
let passwordGeneratorTimeout = null;
function debouncedShowPasswordGeneratorPopup(input) {
    // Clear any existing timeout
    if (passwordGeneratorTimeout) {
        clearTimeout(passwordGeneratorTimeout);
    }
    // Set a new timeout
    passwordGeneratorTimeout = setTimeout(() => {
        showPasswordGeneratorPopup(input);
        passwordGeneratorTimeout = null;
    }, 100); // Reduced to 100ms debounce for faster response
}
function showPasswordGeneratorPopup(input) {
    // Prevent multiple popups from being created
    if (document.getElementById('password-generator-popup')) {
        return;
    }
    // Prevent rapid successive calls for the same input
    if (currentPasswordGeneratorInput === input) {
        return;
    }
    currentPasswordGeneratorInput = input;
    // Check if user is authenticated before showing popup
    const checkAuthentication = () => __awaiter(this, void 0, void 0, function* () {
        try {
            if (!isExtensionContextValid()) {
                // console.log('Extension context not valid, skipping password generator popup');
                return false;
            }
            const authData = yield chrome.storage.local.get(['token', 'userData']);
            if (!authData.token || !authData.userData) {
                // console.log('User not authenticated, skipping password generator popup');
                return false;
            }
            // console.log('User authenticated, showing password generator popup');
            return true;
        }
        catch (error) {
            console.log('Could not check authentication status:', error);
            return false;
        }
    });
    // Check authentication and only proceed if user is logged in
    checkAuthentication().then(isAuthenticated => {
        if (!isAuthenticated) {
            return; // Don't show popup for unauthenticated users
        }
        // Continue with existing popup logic for authenticated users
        removePasswordGeneratorPopup();
        // Simplified theme detection - use system preference directly
        const isDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
        const getRect = () => input.getBoundingClientRect();
        const popup = document.createElement('div');
        popup.id = 'password-generator-popup';
        // Keep popup anchored to the input while scrolling
        popup.style.position = 'fixed';
        const popupWidth = 470;
        popup.style.width = '470px';
        // Calculate optimal height based on viewport - ensure no scrolling needed
        const viewportHeight = window.innerHeight;
        const availableHeight = viewportHeight - 40; // 20px margin top and bottom
        const optimalHeight = Math.min(600, Math.max(400, availableHeight));
        const desiredHeight = optimalHeight;
        const clamp = (val, min, max) => Math.max(min, Math.min(max, val));
        const computePosition = () => {
            const margin = 8;
            const rect = getRect();
            const viewportTop = 0;
            const viewportLeft = 0;
            const viewportRight = viewportLeft + window.innerWidth;
            const viewportBottom = viewportTop + window.innerHeight;
            // Prefer right of input, then left; fallback below/above aligned to input
            const spaceRight = viewportRight - (rect.right + margin);
            const spaceLeft = (rect.left - margin) - viewportLeft;
            let top;
            let left;
            if (spaceRight >= popupWidth) {
                left = rect.right + margin;
                const topRaw = rect.top;
                top = clamp(topRaw, viewportTop + margin, viewportBottom - desiredHeight - margin);
            }
            else if (spaceLeft >= popupWidth) {
                left = rect.left - popupWidth - margin;
                const topRaw = rect.top;
                top = clamp(topRaw, viewportTop + margin, viewportBottom - desiredHeight - margin);
            }
            else {
                const belowTop = rect.bottom + margin;
                const aboveTop = rect.top - desiredHeight - margin;
                const placeAbove = belowTop + desiredHeight > viewportBottom && aboveTop >= viewportTop + margin;
                top = placeAbove ? aboveTop : belowTop;
                const leftRaw = rect.left;
                left = clamp(leftRaw, viewportLeft + margin, viewportRight - popupWidth - margin);
            }
            popup.style.top = `${top}px`;
            popup.style.left = `${left}px`;
        };
        computePosition();
        popup.style.borderRadius = '12px';
        popup.style.boxShadow = isDarkMode
            ? '0 8px 32px rgba(0, 0, 0, 0.6), 0 2px 8px rgba(0, 0, 0, 0.3)'
            : '0 8px 32px rgba(0, 0, 0, 0.15), 0 2px 8px rgba(0, 0, 0, 0.1)';
        popup.style.zIndex = '10000';
        popup.style.fontSize = '14px';
        popup.style.fontFamily = 'system-ui, -apple-system, BlinkMacSystemFont, sans-serif';
        popup.style.padding = '0';
        popup.style.maxHeight = `${desiredHeight}px`;
        popup.style.overflow = 'hidden';
        popup.style.backdropFilter = 'blur(10px)';
        // Simplified loading - show iframe immediately for faster perceived loading
        const loadingIndicator = document.createElement('div');
        loadingIndicator.style.cssText = `
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      color: ${isDarkMode ? '#fff' : '#333'};
      font-size: 14px;
      z-index: 1;
    `;
        loadingIndicator.textContent = 'Loading password generator...';
        popup.appendChild(loadingIndicator);
        const iframe = document.createElement('iframe');
        // Determine a seed password to show in the generator (current value, sibling confirm field, or last generated)
        let seedPassword = '';
        try {
            seedPassword = (input.value || '').trim();
            if (!seedPassword) {
                const form = input.closest('form');
                if (form) {
                    const pwFields = Array.from(form.querySelectorAll('input[type="password"]'));
                    const otherWithValue = pwFields.find(f => f !== input && (f.value || '').trim().length > 0);
                    if (otherWithValue) {
                        seedPassword = (otherWithValue.value || '').trim();
                    }
                }
            }
            if (!seedPassword) {
                seedPassword = window.__defendia_last_generated_password || '';
            }
        }
        catch (_a) { }
        const baseUrl = 'popup.html?view=passwordGeneratorPage&isPopup=true';
        const srcUrl = seedPassword ? `${baseUrl}&seed=${encodeURIComponent(seedPassword)}` : baseUrl;
        iframe.src = chrome.runtime.getURL(srcUrl);
        iframe.style.cssText = `
      width: 470px;
      height: ${desiredHeight}px;
      border-radius: 12px;
      background: transparent;
      display: block;
    `;
        popup.appendChild(iframe);
        document.body.appendChild(popup);
        const onLoad = () => {
            loadingIndicator.style.display = 'none';
        };
        iframe.addEventListener('load', onLoad, { once: true });
        // Faster timeout for better user experience
        setTimeout(() => {
            if (loadingIndicator.style.display !== 'none') {
                console.log('Password generator iframe load timeout, showing anyway');
                loadingIndicator.style.display = 'none';
            }
        }, 500); // Reduced to 0.5 second timeout for faster loading
        const handleClickOutside = (e) => {
            if (!popup.contains(e.target) && e.target !== input) {
                removePasswordGeneratorPopup();
                document.removeEventListener('click', handleClickOutside);
            }
        };
        const handleEscape = (e) => {
            if (e.key === 'Escape') {
                removePasswordGeneratorPopup();
                document.removeEventListener('keydown', handleEscape);
            }
        };
        // Add event listeners
        setTimeout(() => {
            document.addEventListener('click', handleClickOutside);
            document.addEventListener('keydown', handleEscape);
        }, 100);
        const handleReposition = () => computePosition();
        window.addEventListener('scroll', handleReposition, true);
        window.addEventListener('resize', handleReposition);
        // Handle messages from iframe
        const messageListener = (event) => {
            var _a;
            if (event.data && event.data.type === 'PASSWORD_GENERATOR_ACTION') {
                switch (event.data.action) {
                    case 'USE_PASSWORD':
                        if (event.data.password) {
                            setElementValue(input, event.data.password);
                            try {
                                window.__defendia_last_generated_password = event.data.password;
                            }
                            catch (_b) { }
                            // Auto-fill confirm password field if it exists
                            const form = input.closest('form');
                            if (form) {
                                const confirmPasswordField = form.querySelector('input[type="password"][name*="confirm"], input[type="password"][name*="reenter"], input[type="password"][name*="re-enter"], input[type="password"][id*="confirm"], input[type="password"][id*="reenter"], input[type="password"][id*="re-enter"], input[type="password"][placeholder*="confirm"], input[type="password"][placeholder*="re-enter"]');
                                if (confirmPasswordField && confirmPasswordField !== input) {
                                    setElementValue(confirmPasswordField, event.data.password);
                                }
                            }
                            removePasswordGeneratorPopup();
                        }
                        break;
                    case 'CLOSE_POPUP':
                        removePasswordGeneratorPopup();
                        break;
                    case 'COPY_PASSWORD':
                        if (event.data.password) {
                            try {
                                navigator.clipboard.writeText(event.data.password).then(() => {
                                    var _a;
                                    (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.postMessage({
                                        type: 'COPY_RESULT',
                                        success: true
                                    }, '*');
                                }).catch(() => {
                                    var _a, _b;
                                    const textArea = document.createElement('textarea');
                                    textArea.value = event.data.password;
                                    textArea.style.position = 'fixed';
                                    textArea.style.left = '-999999px';
                                    textArea.style.top = '-999999px';
                                    document.body.appendChild(textArea);
                                    textArea.focus();
                                    textArea.select();
                                    try {
                                        document.execCommand('copy');
                                        (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.postMessage({
                                            type: 'COPY_RESULT',
                                            success: true
                                        }, '*');
                                    }
                                    catch (err) {
                                        (_b = iframe.contentWindow) === null || _b === void 0 ? void 0 : _b.postMessage({
                                            type: 'COPY_RESULT',
                                            success: false,
                                            error: 'Copy failed'
                                        }, '*');
                                    }
                                    document.body.removeChild(textArea);
                                });
                            }
                            catch (err) {
                                (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.postMessage({
                                    type: 'COPY_RESULT',
                                    success: false,
                                    error: 'Copy failed'
                                }, '*');
                            }
                        }
                        break;
                }
            }
        };
        window.addEventListener('message', messageListener);
        popup.messageListener = messageListener;
        popup.cleanup = () => {
            try {
                window.removeEventListener('scroll', handleReposition, true);
            }
            catch (_a) { }
            try {
                window.removeEventListener('resize', handleReposition);
            }
            catch (_b) { }
            try {
                iframe.removeEventListener('load', onLoad);
            }
            catch (_c) { }
        };
    });
}


/***/ })

/******/     });
/************************************************************************/
/******/
/******/     // startup
/******/     // Load entry module and return exports
/******/     // This entry module is referenced by other modules so it can't be inlined
/******/     var __webpack_exports__ = {};
/******/     __webpack_modules__["./src/content/index.ts"]();
/******/
/******/ })()
;
//# sourceMappingURL=content.js.map
